package ru.yandex.calendar.frontend.ews.imp;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.resource.UidOrResourceId;

public class EwsImportResult {
    private final EwsImportStatus status;
    private final ListF<Long> affectedLayerIds;
    private final UidOrResourceId subjectId;

    public EwsImportResult(EwsImportStatus status, ListF<Long> affectedLayerIds, UidOrResourceId subjectId) {
        this.status = status;
        this.affectedLayerIds = affectedLayerIds;
        this.subjectId = subjectId;
    }

    public EwsImportStatus getStatus() {
        return status;
    }

    public ListF<Long> getAffectedLayerIds() {
        return affectedLayerIds;
    }

    public UidOrResourceId getSubjectId() {
        return subjectId;
    }

    public static Function<EwsImportResult, EwsImportStatus> getStatusF() {
        return EwsImportResult::getStatus;
    }

    public static Function<EwsImportResult, ListF<Long>> getAffectedLayerIdsF() {
        return EwsImportResult::getAffectedLayerIds;
    }
}
