package ru.yandex.calendar.frontend.ews.imp;

import com.microsoft.schemas.exchange.services._2006.types.CalendarItemType;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.frontend.ews.ExtendedCalendarItemProperties;
import ru.yandex.calendar.logic.event.model.EventData;

/**
 * @author dbrylev
 */
public class ExchangeEventData {
    private final CalendarItemType calendarItem;
    private final EventData eventData;
    private final ExtendedCalendarItemProperties extendedProperties;

    public ExchangeEventData(
            CalendarItemType calendarItem, EventData eventData,
            ExtendedCalendarItemProperties extendedProperties)
    {
        this.calendarItem = calendarItem;
        this.eventData = eventData;
        this.extendedProperties = extendedProperties;
    }

    public CalendarItemType getCalendarItem() {
        return calendarItem;
    }

    public EventData getEventData() {
        return eventData;
    }

    public ExtendedCalendarItemProperties getExtendedProperties() {
        return extendedProperties;
    }

    public Option<Instant> getRecurrenceId() {
        return eventData.getEvent().getRecurrenceId();
    }

    public static Function<ExchangeEventData, Option<Instant>> getRecurrenceIdF() {
        return new Function<ExchangeEventData, Option<Instant>>() {
            public Option<Instant> apply(ExchangeEventData d) {
                return d.getRecurrenceId();
            }
        };
    }
}
