package ru.yandex.calendar.frontend.ews.proxy;

import java.util.Optional;

import lombok.val;

import ru.yandex.calendar.frontend.ews.exp.EwsModifyingItemId;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.ActorId;
import ru.yandex.calendar.logic.log.EventIdLogDataJson;
import ru.yandex.calendar.logic.resource.UidOrResourceId;

public class EwsActionLogData {
    public final Optional<EwsEventIdLogDataJson> logEventId;
    public final ActionInfo actionInfo;

    public EwsActionLogData(
            UidOrResourceId subjectId, EventIdLogDataJson eventLogId, ActionInfo actionInfo)
    {
        this(new EwsEventIdLogDataJson(ActorId.userOrResource(subjectId).toSerializedString(), eventLogId), actionInfo);
    }

    public EwsActionLogData(EwsEventIdLogDataJson logEventId, ActionInfo actionInfo) {
        this.logEventId = Optional.of(logEventId);
        this.actionInfo = actionInfo;
    }

    private EwsActionLogData() {
        this.logEventId = Optional.empty();
        this.actionInfo = ActionInfo.exchangeTest();
    }

    public static EwsActionLogData test() {
        return new EwsActionLogData();
    }

    public ExchangeIdLogData consExchangeId(String exchangeId) {
        return logEventId.map(ewsEventIdLogDataJson -> new ExchangeIdLogData(exchangeId, ewsEventIdLogDataJson)).orElseGet(() -> ExchangeIdLogData.test(exchangeId));
    }

    public EwsActionLogData forItem(EwsModifyingItemId itemId) {
        if (logEventId.isPresent() && itemId.isOccurrence()) {
            val id = logEventId.get();

            return new EwsActionLogData(new EwsEventIdLogDataJson(
                    id.subject, id.eventLogId.withRecurrenceId(itemId.getOccurrenceId())), actionInfo);
        }
        return this;
    }
}
