package ru.yandex.calendar.frontend.ews.proxy;

import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.microsoft.schemas.exchange.services._2006.types.CalendarItemCreateOrDeleteOperationType;
import com.microsoft.schemas.exchange.services._2006.types.CalendarItemUpdateOperationType;
import com.microsoft.schemas.exchange.services._2006.types.MessageDispositionType;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Either;
import ru.yandex.calendar.logic.log.EventIdLogDataJson;
import ru.yandex.calendar.logic.log.LogEvent;
import ru.yandex.calendar.logic.log.LogEventType;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class EwsCallLogEventJson extends LogEvent {
    private final EwsCallOperation operation;
    @JsonUnwrapped
    private final Optional<EwsEventIdLogDataJson> logEvent;
    private final Optional<Instant> occurrence;
    private final Optional<MessageDispositionType> disposition;
    private final String invitations;
    private final Optional<String> error;

    public EwsCallLogEventJson(
            EwsCallOperation operation, Optional<EwsEventIdLogDataJson> logEventId,
            Optional<Instant> occurrence, Optional<MessageDispositionType> disposition,
            Either<CalendarItemCreateOrDeleteOperationType, CalendarItemUpdateOperationType> invitations,
            Optional<String> error)
    {
        this.operation = operation;
        this.logEvent = logEventId;
        this.occurrence = occurrence;
        this.disposition = disposition;
        this.error = error;
        this.invitations = invitations.leftO().map(Enum::toString).orElse(invitations.rightO().map(Enum::toString)).get();
    }

    @JsonGetter
    @Override
    public LogEventType type() {
        return LogEventType.EVENT_EWS_CALL;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    @Override
    public Optional<EventIdLogDataJson> getEventId() {
        return logEvent.map(e -> e.eventLogId);
    }
}
