package ru.yandex.calendar.frontend.ews.proxy;

import java.util.List;

import com.microsoft.schemas.exchange.services._2006.messages.GetEventsResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.ResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.types.BaseItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.CalendarItemCreateOrDeleteOperationType;
import com.microsoft.schemas.exchange.services._2006.types.CalendarItemType;
import com.microsoft.schemas.exchange.services._2006.types.CalendarItemUpdateOperationType;
import com.microsoft.schemas.exchange.services._2006.types.ItemChangeDescriptionType;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.ItemType;
import com.microsoft.schemas.exchange.services._2006.types.MessageDispositionType;
import com.microsoft.schemas.exchange.services._2006.types.UnindexedFieldURIType;
import org.joda.time.Minutes;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.calendar.frontend.ews.subscriber.EwsSubscribeResult;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.time.InstantInterval;

public interface EwsProxy {
    EwsSubscribeResult subscribeToPush(Email email);

    EwsSubscribeResult subscribeToPull(Email email, Minutes timeout, Option<String> watermark);

    ResponseMessageType unsubscribe(String subscriptionId);

    ListF<CalendarItemType> getEvents(ListF<? extends  BaseItemIdType> itemIds, final boolean idOnly);

    ListF<CalendarItemType> getEvents(
        ListF<? extends BaseItemIdType> itemIds, ListF<UnindexedFieldURIType> fields, ListF<String> extendedFields);

    Tuple2List<ItemType, ResponseMessageType> createItems(Option<Email> emailO, ListF<? extends ItemType> items,
                                                          MessageDispositionType dispostinion, CalendarItemCreateOrDeleteOperationType operationType);

    ListF<CalendarItemType> findInstanceEvents(Email email, InstantInterval interval, boolean idOnly);

    ListF<CalendarItemType> findInstanceEvents(
        Email email, InstantInterval interval, ListF<UnindexedFieldURIType> fields, ListF<String> extendedFields);

    ListF<CalendarItemType> findMasterAndSingleEvents(Email email, Option<InstantInterval> intervalO, boolean idOnly);

    ListF<CalendarItemType> findMasterAndSingleEvents(
        Email email, Option<InstantInterval> interval, List<UnindexedFieldURIType> fields, ListF<String> extendedFields);

    GetEventsResponseMessageType pull(String subscriptionId, String watermark);

    ResponseMessageType updateItem(ItemIdType itemId, ListF<? extends ItemChangeDescriptionType> changeDescriptions);

    ResponseMessageType updateItem(ItemIdType itemId,
                                   ListF<? extends ItemChangeDescriptionType> changeDescriptions,
                                   CalendarItemUpdateOperationType operationType);

    Tuple2List<String, ResponseMessageType> deleteEvents(
        ListF<String> exchangeIds, CalendarItemCreateOrDeleteOperationType operationType);

    boolean ping();

    List<CalendarItemType> findInstanceEventsForPurging(Email email, int limit);
}
