package ru.yandex.calendar.frontend.ews.proxy;

import java.util.Optional;

import ru.yandex.calendar.logic.log.EventIdLogDataJson;
import ru.yandex.calendar.logic.resource.UidOrResourceId;

public class ExchangeIdLogData {
    public final String exchangeId;
    public final Optional<EwsEventIdLogDataJson> logEventId;

    public ExchangeIdLogData(String exchangeId, UidOrResourceId subjectId, EventIdLogDataJson eventLogId) {
        this(exchangeId, new EwsEventIdLogDataJson(subjectId.toString(), eventLogId));
    }

    public ExchangeIdLogData(String exchangeId, EwsEventIdLogDataJson logEventId) {
        this.exchangeId = exchangeId;
        this.logEventId = Optional.of(logEventId);
    }

    private ExchangeIdLogData(String exchangeId) {
        this.exchangeId = exchangeId;
        this.logEventId = Optional.empty();
    }

    public static ExchangeIdLogData test(String exchangeId) {
        return new ExchangeIdLogData(exchangeId);
    }
}
