package ru.yandex.calendar.frontend.ews.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicInteger;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.xml.ws.Holder;

import com.microsoft.schemas.exchange.services._2006.messages.BaseRequestType;
import com.microsoft.schemas.exchange.services._2006.messages.BaseResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.ExchangeServicePortType;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.misc.reflection.MethodParameter;
import ru.yandex.misc.reflection.MethodX;

/**
 * @author dbrylev
 */
public class ExchangeLoggingServiceProxy implements InvocationHandler {

    private static final AtomicInteger counter = new AtomicInteger();

    private final ExchangeServicePortType target;

    public ExchangeLoggingServiceProxy(ExchangeServicePortType target) {
        this.target = target;
    }

    public static ExchangeServicePortType of(ExchangeServicePortType service) {
        return (ExchangeServicePortType) Proxy.newProxyInstance(
                ExchangeServicePortType.class.getClassLoader(),
                new Class<?>[] { ExchangeServicePortType.class },
                new ExchangeLoggingServiceProxy(service));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Tuple2List<MethodParameter, Integer> params = MethodX.wrap(method).getParameters().zipWithIndex();

        Option<Tuple2<MethodParameter, Integer>> reqParam = params
                .findBy1(p -> p.getClazz().isAssignableTo(BaseRequestType.class));

        Option<Tuple2<MethodParameter, Integer>> respParam = params
                .findBy1(p -> p.getClazz().sameAs(Holder.class) && p.getType().getActualTypeArguments()
                        .exists(t -> t.asClass().isAssignableTo(BaseResponseMessageType.class)));

        if (method.getName().equals("getUserOofSettings")
                || method.getAnnotation(WebMethod.class) == null
                || !reqParam.isPresent() || !respParam.isPresent())
        {
            return method.invoke(target, args);
        }

        ExchangeInvocation invocation = new ExchangeInvocation(
                nextNum(), method.getName(),
                reqParam.get().get1().getAnnotation(WebParam.class),
                respParam.get().get1().getAnnotation(WebParam.class));

        ExchangeRequestLogger.log(invocation,
                (BaseRequestType) args[reqParam.get().get2()]);
        try {
            Object result = method.invoke(target, args);

            ExchangeRequestLogger.log(invocation,
                    (BaseResponseMessageType) ((Holder) args[respParam.get().get2()]).value);

            return result;

        } catch (InvocationTargetException e) {
            ExchangeRequestLogger.log(invocation, e.getCause());

            throw e.getCause();
        }
    }

    private static int nextNum() {
        int num = counter.incrementAndGet();

        if (num >= 100500) {
            if (counter.compareAndSet(num, 1)) {
                num = 1;
            } else {
                num = counter.incrementAndGet();
            }
        }
        return num;
    }
}
