package ru.yandex.calendar.frontend.ews.proxy;

import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonUnwrapped;

import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.misc.net.HostnameUtils;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class ExchangeRequestLogData {
    public String type;
    public Optional<String> body = Optional.empty();
    public int num;
    public String method;
    public Optional<String> error = Optional.empty();
    @JsonUnwrapped
    public ActionInfo actionInfo;
    private String host;

    ExchangeRequestLogData() {
        host = HostnameUtils.localHostnameShort();
    }
}
