package ru.yandex.calendar.frontend.ews.proxy;

import javax.xml.ws.Holder;

import com.microsoft.schemas.exchange.services._2006.messages.CreateItemResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.CreateItemType;
import com.microsoft.schemas.exchange.services._2006.messages.DeleteItemResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.DeleteItemType;
import com.microsoft.schemas.exchange.services._2006.messages.ExchangeServicePortType;
import com.microsoft.schemas.exchange.services._2006.messages.FindItemResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.FindItemType;
import com.microsoft.schemas.exchange.services._2006.messages.GetEventsResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.GetEventsType;
import com.microsoft.schemas.exchange.services._2006.messages.GetItemResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.GetItemType;
import com.microsoft.schemas.exchange.services._2006.messages.GetUserOofSettingsRequest;
import com.microsoft.schemas.exchange.services._2006.messages.GetUserOofSettingsResponse;
import com.microsoft.schemas.exchange.services._2006.messages.SubscribeResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.SubscribeType;
import com.microsoft.schemas.exchange.services._2006.messages.UnsubscribeResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.UnsubscribeType;
import com.microsoft.schemas.exchange.services._2006.messages.UpdateItemResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.UpdateItemType;
import com.microsoft.schemas.exchange.services._2006.types.ExchangeVersionType;
import com.microsoft.schemas.exchange.services._2006.types.RequestServerVersion;
import com.microsoft.schemas.exchange.services._2006.types.ServerVersionInfo;

/**
 * @author Sergey Galyamichev
 */
public class ExchangeService {
    private ExchangeServicePortType espt;

    public ExchangeService(ExchangeServicePortType espt) {
        this.espt = espt;
    }

    public SubscribeResponseType subscribe(SubscribeType request) {
        return call(request, espt::subscribe);
    }

    public UnsubscribeResponseType unsubscribe(UnsubscribeType request) {
        return call(request, espt::unsubscribe);
    }

    public CreateItemResponseType createItem(CreateItemType request) {
        return call(request, espt::createItem);
    }

    public UpdateItemResponseType updateItem(UpdateItemType request) {
        return call(request, espt::updateItem);
    }

    public GetItemResponseType getItem(GetItemType request) {
        return call(request, espt::getItem);
    }

    public FindItemResponseType findItem(FindItemType request) {
        return call(request, espt::findItem);
    }

    public DeleteItemResponseType deleteItem(DeleteItemType request) {
        return call(request, espt::deleteItem);
    }

    public GetEventsResponseType getEvents(GetEventsType request) {
        return call(request, espt::getEvents);
    }

    public GetUserOofSettingsResponse getUserOofSettings(GetUserOofSettingsRequest request) {
        // what is the reason why we skipped request version before???
        return call(request, espt::getUserOofSettings);
    }

    private RequestServerVersion create2010RequestVersion() {
        RequestServerVersion requestVersion = new RequestServerVersion();
        requestVersion.setVersion(ExchangeVersionType.EXCHANGE_2010_SP_2);
        return requestVersion;
    }

    public <R, T> R call(T request, SoapCall<R, T> call) {
        Holder<R> response = new Holder<>();
        Holder<ServerVersionInfo> serverVersion = new Holder<>();
        call.call(request, create2010RequestVersion(), response, serverVersion);
        return response.value;
    }

    interface SoapCall<R, T> {
        void call(T request, RequestServerVersion rv, Holder<R> response, Holder<ServerVersionInfo> sv);
    }
}
