package ru.yandex.calendar.frontend.ews.proxy;

import java.util.UUID;

import org.mockito.stubbing.OngoingStubbing;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;

import static org.mockito.Matchers.any;
import static org.mockito.Matchers.anyBoolean;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

/**
 * @author yashunsky
 */
public class MockEwsProxyWrapperFactory {
    private static final int DEFAULT_RANDOM_EXCHANGE_IDS_COUNT = 10;

    private static void addListOfRandomResults(OngoingStubbing<Object> input, int randomExchangeIdsCount) {
        for (int i = 0; i < randomExchangeIdsCount; i++) {
            input = input.thenReturn(UUID.randomUUID().toString());
        }
    }

    public static EwsProxyWrapper getMockEwsProxyWrapperForTest() {
        return getMockEwsProxyWrapperForTest(DEFAULT_RANDOM_EXCHANGE_IDS_COUNT);
    }

    public static EwsProxyWrapper getMockEwsProxyWrapperForTest(int randomExchangeIdsCount) {
        EwsProxyWrapper mockProxy = mock(EwsProxyWrapper.class);

        addListOfRandomResults(when(mockProxy.createEvent(any(), any(), any())), randomExchangeIdsCount);
        addListOfRandomResults(when(mockProxy.createEvent(any(), any(), any(), any(), any())), randomExchangeIdsCount);
        when(mockProxy.createEventSafe(any(), any(), any())).thenReturn(Option.empty());
        when(mockProxy.findInstanceEventIds(any(), any())).thenReturn(Cf.list());
        when(mockProxy.findInstanceEventIdsByExternalId(any(), any(), any())).thenReturn(Cf.list());
        when(mockProxy.findInstanceEvents(any(), any(), any(), any())).thenReturn(Cf.list());

        when(mockProxy.updateItem(any(), any(), any())).thenReturn(Option.empty());
        when(mockProxy.updateItem(any(), any(), any())).thenReturn(Option.empty());
        when(mockProxy.getEvents(any())).thenReturn(Cf.list());
        when(mockProxy.getEvents(any(), any())).thenReturn(Cf.list());
        when(mockProxy.getEvents(any(), any(), any())).thenReturn(Cf.list());
        when(mockProxy.findRecurringMasterIdsByInstanceIds(any())).thenReturn(new Tuple2List<>(Cf.list()));
        when(mockProxy.findMasterAndSingleEventIdsByExternalId(any(), any(), any())).thenReturn(Cf.list());

        when(mockProxy.setUserDecision(any(), any(), any(), any(), any(), any())).thenReturn(true);

        when(mockProxy.findMasterAndSingleOrInstanceEventId(any(), any(), any(), anyBoolean()))
                .thenReturn(Option.empty());

        return mockProxy;
    }

}
