package ru.yandex.calendar.frontend.ews.replace;

import com.microsoft.schemas.exchange.services._2006.types.CalendarItemType;
import com.microsoft.schemas.exchange.services._2006.types.CalendarItemTypeType;

import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.frontend.ews.EwsUtils;
import ru.yandex.calendar.frontend.ews.proxy.ExchangeIdLogData;
import ru.yandex.calendar.logic.log.EventIdLogDataJson;
import ru.yandex.calendar.logic.resource.UidOrResourceId;
import ru.yandex.calendar.logic.sharing.participant.ResourceParticipantInfo;
import ru.yandex.commune.util.serialize.reflect.ReflectionToMultilineStringSerializeMe;

/**
 * @author Daniel Brylev
 */
@ReflectionToMultilineStringSerializeMe
class ExchangeResourceMeeting extends ResourceMeeting {

    private final int conflictingMeetingCount;
    private final boolean wasCreatedFromYaTeamCalendar;
    private final CalendarItemTypeType itemType;

    public ExchangeResourceMeeting(ResourceParticipantInfo resourceParticipant, CalendarItemType item) {
        super(resourceParticipant, new ExchangeIdLogData(
                item.getItemId().getId(), UidOrResourceId.resource(resourceParticipant),
                new EventIdLogDataJson(0L, 0L, item.getUID(), EwsUtils.getRecurrenceId(item).toOptional())));

        this.conflictingMeetingCount = item.getConflictingMeetingCount();
        this.itemType = item.getCalendarItemType();
        this.wasCreatedFromYaTeamCalendar = EwsUtils.convertExtendedProperties(item).getWasCreatedFromYaTeamCalendar();
    }

    public int getConflictingMeetingCount() {
        return conflictingMeetingCount;
    }

    public boolean isMasterOrSingle() {
        return itemType == CalendarItemTypeType.RECURRING_MASTER || itemType == CalendarItemTypeType.SINGLE;
    }

    public boolean wasCreatedFromYaTeamCalendar() {
        return wasCreatedFromYaTeamCalendar;
    }

    public static Function<ExchangeResourceMeeting, Integer> getConflictingMeetingCountF() {
        return new Function<ExchangeResourceMeeting, Integer>() {
            public Integer apply(ExchangeResourceMeeting m) {
                return m.getConflictingMeetingCount();
            }
        };
    }

    public static Function1B<ExchangeResourceMeeting> isMasterOrSingleF() {
        return new Function1B<ExchangeResourceMeeting>() {
            public boolean apply(ExchangeResourceMeeting m) {
                return m.isMasterOrSingle();
            }
        };
    }

    public static Function1B<ExchangeResourceMeeting> wasCreatedFromYaCalendarF() {
        return new Function1B<ExchangeResourceMeeting>() {
            public boolean apply(ExchangeResourceMeeting m) {
                return m.wasCreatedFromYaTeamCalendar();
            }
        };
    }
}
