package ru.yandex.calendar.frontend.ews.replace;

import com.microsoft.schemas.exchange.services._2006.types.CalendarItemType;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.event.EventInfo;

/**
 * @author Daniel Brylev
 */
class MasterCreateData {
    private final EventInfo eventInfo;
    private final CalendarItemType createData;
    private final ListF<Instant> exdates;

    public MasterCreateData(EventInfo eventInfo, CalendarItemType createData, ListF<Instant> exdates) {
        this.eventInfo = eventInfo;
        this.createData = createData;
        this.exdates = exdates;
    }

    public EventInfo getEventInfo() {
        return eventInfo;
    }

    public CalendarItemType getCreateData() {
        return createData;
    }

    public ListF<Instant> getExdates() {
        return exdates;
    }
}
