package ru.yandex.calendar.frontend.ews.replace;

import com.microsoft.schemas.exchange.services._2006.types.CalendarItemType;
import com.microsoft.schemas.exchange.services._2006.types.ItemChangeDescriptionType;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.event.EventInfo;

/**
 * @author Daniel Brylev
 */
class RecurrenceCreateData {
    private final EventInfo eventInfo;
    private final CalendarItemType createData;
    private final Instant recurrenceId;
    private final ListF<ItemChangeDescriptionType> updateData;

    public RecurrenceCreateData(
            EventInfo eventInfo,
            CalendarItemType createData,
            Instant recurrenceId,
            ListF<ItemChangeDescriptionType> updateData)
    {
        this.eventInfo = eventInfo;
        this.createData = createData;
        this.recurrenceId = recurrenceId;
        this.updateData = updateData;
    }

    public EventInfo getEventInfo() {
        return eventInfo;
    }

    public CalendarItemType getCreateData() {
        return createData;
    }

    public Instant getRecurrenceId() {
        return recurrenceId;
    }

    public ListF<ItemChangeDescriptionType> getUpdateData() {
        return updateData;
    }
}
