package ru.yandex.calendar.frontend.ews.replace;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.sharing.participant.ResourceParticipantInfo;

/**
 * @author Daniel Brylev
 */
class RecurrenceReplaceResourcesInfo {
    private final ListF<ResourceParticipantInfo> resourcesToModifyOccurrence;
    private final ListF<ResourceParticipantInfo> resourcesToCreateSingleMeeting;
    private final ListF<Long> resourceIdsToCancelOccurrence;

    public RecurrenceReplaceResourcesInfo(
            ListF<ResourceParticipantInfo> resourcesToModifyOccurrence,
            ListF<ResourceParticipantInfo> resourcesToCreateSingleMeeting,
            ListF<Long> resourceIdsToCancelOccurrence)
    {
        this.resourcesToModifyOccurrence = resourcesToModifyOccurrence;
        this.resourcesToCreateSingleMeeting = resourcesToCreateSingleMeeting;
        this.resourceIdsToCancelOccurrence = resourceIdsToCancelOccurrence;
    }

    public ListF<ResourceParticipantInfo> getResourcesToModifyOccurrence() {
        return resourcesToModifyOccurrence;
    }

    public ListF<ResourceParticipantInfo> getResourcesToCreateSingleMeeting() {
        return resourcesToCreateSingleMeeting;
    }

    public ListF<Long> getResourceIdsToCancelOccurrence() {
        return resourceIdsToCancelOccurrence;
    }
}
