package ru.yandex.calendar.frontend.ews.replace;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.calendar.logic.sharing.participant.ResourceParticipantInfo;

/**
 * @author Daniel Brylev
 */
class ReplaceResourcesInfo {
    private final ListF<ResourceParticipantInfo> resourcesToReplaceMaster;
    private final MapF<Long, RecurrenceReplaceResourcesInfo> recurrenceReplaceInfoByEventId;

    public ReplaceResourcesInfo(
            ListF<ResourceParticipantInfo> resourcesToReplaceMaster,
            MapF<Long, RecurrenceReplaceResourcesInfo> recurrenceReplaceInfoByEventId)
    {
        this.resourcesToReplaceMaster = resourcesToReplaceMaster;
        this.recurrenceReplaceInfoByEventId = recurrenceReplaceInfoByEventId;
    }

    public ListF<ResourceParticipantInfo> getResourcesToReplaceMaster() {
        return resourcesToReplaceMaster;
    }

    public RecurrenceReplaceResourcesInfo getRecurrenceReplaceResourcesInfo(long recurrenceEventId) {
        return recurrenceReplaceInfoByEventId.getOrThrow(recurrenceEventId);
    }
}
