package ru.yandex.calendar.frontend.ews.replace;

import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.frontend.ews.proxy.ExchangeIdLogData;
import ru.yandex.calendar.logic.beans.generated.Resource;
import ru.yandex.calendar.logic.sharing.participant.ResourceParticipantInfo;

/**
 * @author Daniel Brylev
 */
class ResourceMeeting {
    private final ResourceParticipantInfo resourceParticipant;
    private final ExchangeIdLogData exchangeId;

    public ResourceMeeting(ResourceParticipantInfo resourceParticipant, ExchangeIdLogData exchangeId) {
        this.resourceParticipant = resourceParticipant;
        this.exchangeId = exchangeId;
    }

    public ResourceParticipantInfo getResourceParticipant() {
        return resourceParticipant;
    }

    public Resource getResource() {
        return resourceParticipant.getResource();
    }

    public long getEventId() {
        return resourceParticipant.getEventId();
    }

    public String getExchangeId() {
        return exchangeId.exchangeId;
    }

    public ExchangeIdLogData getExchangeIdLogData() {
        return exchangeId;
    }

    public static Function<ResourceMeeting, ResourceParticipantInfo> getResourceParticipantF() {
        return new Function<ResourceMeeting, ResourceParticipantInfo>() {
            public ResourceParticipantInfo apply(ResourceMeeting m) {
                return m.getResourceParticipant();
            }
        };
    }

    public static Function<ResourceMeeting, Long> getResourceIdF() {
        return getResourceParticipantF().andThen(ResourceParticipantInfo.getResourceIdF());
    }

    public static Function<ResourceMeeting, Long> getEventIdF() {
        return new Function<ResourceMeeting, Long>() {
            public Long apply(ResourceMeeting m) {
                return m.getEventId();
            }
        };
    }

    public static Function<ResourceMeeting, String> getExchangeIdF() {
        return new Function<ResourceMeeting, String>() {
            public String apply(ResourceMeeting m) {
                return m.getExchangeId();
            }
        };
    }
}
