package ru.yandex.calendar.frontend.ews.subscriber;

import com.microsoft.schemas.exchange.services._2006.messages.ResponseMessageType;
import org.jdom.Element;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.lang.Validate;

/**
 * @author akirakozov
 */
public class EwsSubscribeResult {
    private final Option<String> subscriptionId;
    private final Option<String> watermark;
    private final ResponseMessageType responseMessage;
    private final Email lastAttemptEmail;

    public EwsSubscribeResult(
            Option<String> subscriptionId,
            Option<String> watermark,
            ResponseMessageType responseMessage,
            Email lastAttemptEmail)
    {
        Validate.notNull(responseMessage);
        Validate.notNull(lastAttemptEmail);
        this.subscriptionId = subscriptionId;
        this.watermark = watermark;
        this.responseMessage = responseMessage;
        this.lastAttemptEmail = lastAttemptEmail;
    }

    public Option<String> getSubscriptionId() {
        return subscriptionId;
    }

    public Option<String> getWatermark() {
        return watermark;
    }

    public ResponseMessageType getResponseMessage() {
        return responseMessage;
    }

    public Email getLastAttemptEmail() {
        return lastAttemptEmail;
    }

    public Element toXmlElement() {
        Element responseElement = new Element("response");
        CalendarXmlizer.appendElm(responseElement, "class", responseMessage.getResponseClass().value());
        CalendarXmlizer.appendElm(responseElement, "message", responseMessage.getMessageText());
        CalendarXmlizer.appendElm(responseElement, "code", responseMessage.getResponseCode());
        if (subscriptionId.isPresent()) {
            CalendarXmlizer.appendElm(responseElement, "subscriptionId", subscriptionId.get());
        }
        CalendarXmlizer.appendElm(responseElement, "lastAttemptEmail", lastAttemptEmail);
        return responseElement;
    }
}
