package ru.yandex.calendar.frontend.ews.sync;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;
import ru.yandex.misc.lang.CamelWords;

/**
 * @author ssytnik
 */
public enum IgnoreReason implements StringEnum {
    /**
     * E.g. RelativeMonthlyPattern, RelativeYearlyPattern
     * See http://msdn.microsoft.com/en-us/library/dd633684%28v=EXCHG.80%29.aspx
     */
    UNSUPPORTED_REPETITION,
    /** Exchange sends canceled event, but it does not exists in calendar */
    CANCELED_EVENT_NOT_FOUND,
    /**
     * E.g. /O=YANDEX/OU=FIRST ADMINISTRATIVE GROUP/CN=RECIPIENTS/CN=SANDREEV
     * We believe such events are of old format / broken.
     */
    BAD_ORGANIZER_EMAIL,
    /** Can merge with {@link #BAD_ORGANIZER_EMAIL} as 'BAD_EMAIL' */
    BAD_ATTENDEE_EMAIL,
    /** Corrupt data */
    NO_EVENT_IN_EXCHANGE,
    /** For the same pair [subjectId, eventId] other exchangeId exists in our database */
    IS_A_COPY;
    // TODO handle this: EwsProxyImpl: failed to fetch event: Error ErrorCorruptData: Data is corrupt.

    public static final StringEnumResolver<IgnoreReason> R = StringEnumResolver.r(IgnoreReason.class);

    public String toDbValue() { return CamelWords.parse(this.name()).toDbName(); }

    @Override
    public String value() {
        return toDbValue();
    }
}
