package ru.yandex.calendar.frontend.ews.sync;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.GenericBeanDao;
import ru.yandex.calendar.logic.beans.generated.YtEwsIgnoredEvent;
import ru.yandex.calendar.logic.beans.generated.YtEwsIgnoredEventHelper;
import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;
import ru.yandex.commune.test.random.RunWithRandomTest;

/**
 * @author ssytnik
 */
public class IgnoredEventDao extends CalendarJdbcDaoSupport {
    @Autowired
    private GenericBeanDao genericBeanDao;


    @RunWithRandomTest
    public Option<YtEwsIgnoredEvent> findIgnoredEventByExchangeId(String exchangeId) {
        return genericBeanDao.findBeanById(YtEwsIgnoredEventHelper.INSTANCE, exchangeId);
    }

    public void saveIgnoredEvent(YtEwsIgnoredEvent ignoredEvent) {
        genericBeanDao.insertBeansIgnoreDuplicates(Cf.list(ignoredEvent));
    }
}
