package ru.yandex.calendar.frontend.ews.sync;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.YtEwsIgnoredEvent;
import ru.yandex.misc.lang.Validate;

/**
 * @author ssytnik
 */
public class IgnoredEventManager {
    @Autowired
    private IgnoredEventDao ignoredEventDao;

    public void storeIgnoredEventSafe(String exchangeId, IgnoreReason reason, Option<String> message) {
        Validate.notNull(exchangeId);
        Validate.notNull(reason);
        Validate.notNull(message);
        {
            YtEwsIgnoredEvent ignoredEvent = new YtEwsIgnoredEvent();
            ignoredEvent.setExchangeId(exchangeId);
            ignoredEvent.setReason(reason);
            ignoredEvent.setMessage(message.getOrElse("") + System.currentTimeMillis());
            ignoredEventDao.saveIgnoredEvent(ignoredEvent);
        }
    }
}
