package ru.yandex.calendar.frontend.ews.sync;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.GenericBeanDao;
import ru.yandex.calendar.logic.beans.generated.YtEwsOrgCache;
import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;
import ru.yandex.commune.test.random.RunWithRandomTest;
import ru.yandex.misc.email.Email;

/**
 * @author ssytnik
 */
public class OrganizerCacheDao extends CalendarJdbcDaoSupport {
    @Autowired
    private GenericBeanDao genericBeanDao;

    @RunWithRandomTest
    public Option<Email> findOrganizerEmailByExchangeId(String exchangeId) {
        String q = "SELECT email FROM yt_ews_org_cache WHERE exchange_id = ?";
        return getJdbcTemplate().queryForOption(q, String.class, exchangeId).map(Email.consF());
    }

    public void saveOrganizerCache(YtEwsOrgCache organizerCache) {
        genericBeanDao.insertBeansIgnoreDuplicates(Cf.list(organizerCache));
    }
}
