package ru.yandex.calendar.frontend.ews.sync;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.logic.beans.generated.YtEwsOrgCache;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.lang.Validate;

/**
 * @author ssytnik
 */
public class OrganizerCacheManager {
    @Autowired
    private OrganizerCacheDao organizerCacheDao;

    public void storeOrganizerCacheSafe(String exchangeId, Email email) {
        Validate.notNull(exchangeId);
        Validate.notNull(email);
        {
            YtEwsOrgCache orgCache = new YtEwsOrgCache();
            orgCache.setExchangeId(exchangeId);
            orgCache.setEmail(email);
            organizerCacheDao.saveOrganizerCache(orgCache);
        }
    }
}
