package ru.yandex.calendar.frontend.ews.sync;

import java.util.EnumMap;
import java.util.Map;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.ews.imp.EwsImportStatus;

/**
 * @author ssytnik
 */
class SyncStats {
    private int processedCount = 0; // <= sum(processedByStatusCount) due to recurrence-ids
    private EnumMap<EwsImportStatus, Integer> processedByStatusCount =
        new EnumMap<EwsImportStatus, Integer>(EwsImportStatus.class);
    private int ignoredCount = 0;
    private int errorsCount = 0;
    private int subscriptionErrorsCount = 0;

    public void incProcessedCount() { processedCount++; }
    public void incProcessedByStatusCount(EwsImportStatus status) { addProcessedByStatusCount(status, 1); }
    public void incIgnoredCount() { ignoredCount++; }
    public void incErrorsCount() { errorsCount++; }
    public void incSubscriptionErrorsCount() { subscriptionErrorsCount++; }

    private int getProcessedByStatusCount(EwsImportStatus status) {
        Integer res = processedByStatusCount.get(status);
        return res == null ? 0 : res;
    }

    private void addProcessedByStatusCount(EwsImportStatus status, int add) {
        processedByStatusCount.put(status, getProcessedByStatusCount(status) + add);
    }

    public void add(SyncStats other) {
        this.processedCount += other.processedCount;
        this.ignoredCount += other.ignoredCount;
        for (Map.Entry<EwsImportStatus, Integer> otherEntry : other.processedByStatusCount.entrySet()) {
            addProcessedByStatusCount(otherEntry.getKey(), otherEntry.getValue());
        }
        this.errorsCount += other.errorsCount;
        this.subscriptionErrorsCount += other.subscriptionErrorsCount;
    }

    @Override
    public String toString() {
        ListF<String> processedByStatus = Cf.arrayList();
        for (Map.Entry<EwsImportStatus, Integer> entry : processedByStatusCount.entrySet()) {
            String name = entry.getKey().toString().toLowerCase();
            int value = getProcessedByStatusCount(entry.getKey());
            processedByStatus.add(name + ": " + value);
        }
        return
            "Events processed: " + processedCount + " " +
            "(" + processedByStatus.mkString(", ") + "), " +
            "ignored: " + ignoredCount + ", " +
            "errors: " + errorsCount +
            (subscriptionErrorsCount > 0 ? ", subscription errors: " + subscriptionErrorsCount : "") +
            ".";
    }
}
