package ru.yandex.calendar.frontend.ews.xml;

import java.io.InputStream;
import java.io.Reader;

import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;

import com.ctc.wstx.stax.WstxInputFactory;

/**
 * @author dbrylev
 */
public class NullReplacingInputFactory extends XMLInputFactory {

    private static final XMLInputFactory factory = new WstxInputFactory();

    @Override
    public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        return factory.createXMLStreamReader(NullReplacingReader.wrap(reader));
    }

    @Override
    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        return factory.createXMLStreamReader(source);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream stream) throws XMLStreamException {
        return factory.createXMLStreamReader(NullReplacingReader.wrap(stream));
    }

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream stream, String encoding) throws XMLStreamException {
        return factory.createXMLStreamReader(NullReplacingReader.wrap(stream, encoding));
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String systemId, InputStream stream) throws XMLStreamException {
        return factory.createXMLStreamReader(systemId, NullReplacingReader.wrap(stream));
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String systemId, Reader reader) throws XMLStreamException {
        return factory.createXMLStreamReader(systemId, NullReplacingReader.wrap(reader));
    }

    @Override
    public XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        return factory.createXMLEventReader(NullReplacingReader.wrap(reader));
    }

    @Override
    public XMLEventReader createXMLEventReader(String systemId, Reader reader) throws XMLStreamException {
        return factory.createXMLEventReader(systemId, NullReplacingReader.wrap(reader));
    }

    @Override
    public XMLEventReader createXMLEventReader(XMLStreamReader reader) throws XMLStreamException {
        return factory.createXMLEventReader(reader);
    }

    @Override
    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        return factory.createXMLEventReader(source);
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream stream) throws XMLStreamException {
        return factory.createXMLEventReader(NullReplacingReader.wrap(stream));
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream stream, String encoding) throws XMLStreamException {
        return factory.createXMLEventReader(NullReplacingReader.wrap(stream, encoding));
    }

    @Override
    public XMLEventReader createXMLEventReader(String systemId, InputStream stream) throws XMLStreamException {
        return factory.createXMLEventReader(systemId, NullReplacingReader.wrap(stream));
    }

    @Override
    public XMLStreamReader createFilteredReader(XMLStreamReader reader, StreamFilter filter) throws XMLStreamException {
        return factory.createFilteredReader(reader, filter);
    }

    @Override
    public XMLEventReader createFilteredReader(XMLEventReader reader, EventFilter filter) throws XMLStreamException {
        return factory.createFilteredReader(reader, filter);
    }

    @Override
    public XMLResolver getXMLResolver() {
        return factory.getXMLResolver();
    }

    @Override
    public void setXMLResolver(XMLResolver resolver) {
        factory.setXMLResolver(resolver);
    }

    @Override
    public XMLReporter getXMLReporter() {
        return factory.getXMLReporter();
    }

    @Override
    public void setXMLReporter(XMLReporter reporter) {
        factory.setXMLReporter(reporter);
    }

    @Override
    public void setProperty(String name, Object value) throws IllegalArgumentException {
        factory.setProperty(name, value);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return factory.getProperty(name);
    }

    @Override
    public boolean isPropertySupported(String name) {
        return factory.isPropertySupported(name);
    }

    @Override
    public void setEventAllocator(XMLEventAllocator allocator) {
        factory.setEventAllocator(allocator);
    }

    @Override
    public XMLEventAllocator getEventAllocator() {
        return factory.getEventAllocator();
    }
}
