package ru.yandex.calendar.frontend.ews.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

import ru.yandex.misc.ExceptionUtils;

/**
 * @author dbrylev
 */
public class NullReplacingReader extends PushbackReader {
    private static final char[] PATTERN = "&#x0;".toCharArray();
    private static final int PATTERN_LEN = PATTERN.length;

    private char[] tokenBuf = new char[PATTERN_LEN];

    public NullReplacingReader(Reader in) {
        super(in, PATTERN_LEN);
    }

    public static NullReplacingReader wrap(Reader in) {
        return new NullReplacingReader(in);
    }

    public static NullReplacingReader wrap(InputStream is) {
        return new NullReplacingReader(new InputStreamReader(is));
    }

    public static NullReplacingReader wrap(InputStream is, String charset) {
        try {
            return new NullReplacingReader(new InputStreamReader(is, charset));
        } catch (UnsupportedEncodingException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        len = super.read(cbuf, off, len);

        return len > 0 ? replace(cbuf, off, len) : len;
    }

    private int replace(char[] cbuf, int off, int len) throws IOException {
        int pos, start = off, end = off + len;

        for (pos = off; off < end - PATTERN_LEN + 1; ++pos) {
            if (matchesSub(cbuf, off, 0, PATTERN_LEN)) {
                cbuf[pos] = '?';
                off += PATTERN_LEN;

            } else {
                cbuf[pos] = cbuf[off];
                off += 1;
            }
        }

        if (pos < off) {
            System.arraycopy(cbuf, off, cbuf, pos, end - off);
            end -= off - pos;
        }

        for (int rest = end - pos; pos < end; ++pos, --rest) {
            if (matchesSub(cbuf, pos, 0, rest)) {

                int remain = PATTERN_LEN - rest;
                int read = readForced(tokenBuf, 0, remain);

                if (read == remain && matchesSub(tokenBuf, 0, rest, remain)) {
                    cbuf[pos] = '?';
                    pos += 1;
                } else {
                    unread(tokenBuf, 0, Math.max(read, 0));
                    pos += rest;
                }
                break;
            }
        }
        return pos - start;
    }

    private boolean matchesSub(char[] target, int targetOff, int patternOff, int len) {
        if (target[targetOff] == PATTERN[patternOff]) {
            int pos;

            for (pos = 1; pos < len; ++pos) {
                if (target[targetOff + pos] != PATTERN[patternOff + pos]) {
                    break;
                }
            }
            return pos == len;
        } else {
            return false;
        }
    }

    private int readForced(char[] target, int off, int req) throws IOException {
        int read = 0;

        while (read < req) {
            int c = super.read(target, off + read, req - read);

            if (c >= 0) {
                read += c;
            } else {
                return read == 0 ? c : read;
            }
        }
        return read;
    }
}
