package ru.yandex.calendar.frontend.kiosk;

import lombok.val;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.calendar.monitoring.WebApiMonitoringConfiguration;
import ru.yandex.calendar.util.JettyConfiguration;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

@Configuration
@Import(
        {WebApiMonitoringConfiguration.class,}
)
public class KioskContextConfiguration {
    @Bean
    public KioskManager kioskManager() {
        return new KioskManager();
    }

    @Bean
    public SingleWarJetty kioskJetty() {
        val jetty = JettyConfiguration.fromProperties("kiosk").consJetty();

        jetty.addServletMapping("/kiosk/*", kioskServlet());

        return jetty;
    }

    @Bean
    public KioskServlet kioskServlet() {
        return new KioskServlet();
    }
}
