package ru.yandex.calendar.frontend.kiosk;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.beans.generated.Resource;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.JsonValue;

/**
 * @author gutman
 */
class Room {
    private final Resource resource;

    public Room(Resource resource) {
        this.resource = resource;
    }

    /**
     * @url http://wiki.yandex-team.ru/Invite/dev/kiosk/cal#rezultat1
     */
    public JsonObject toJson() {
        return new JsonObject(Tuple2List.<String, JsonValue>tuple2List()
                .plus1("title", JsonString.valueOf(resource.getName().getOrElse("undefined")))
                .plus1("name", JsonString.valueOf(resource.getExchangeName().getOrElse("undefined"))));
    }

    public static Function<? super Resource, Room> consF() {
        return new Function<Resource, Room>() {
            public Room apply(Resource resource) {
                return new Room(resource);
            }
        };
    }

    public static Function<Room, JsonValue> toJsonf() {
        return new Function<Room, JsonValue>() {
            public JsonObject apply(Room room) {
                return room.toJson();
            }
        };
    }

}
