package ru.yandex.calendar.frontend.mailhook;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.calendar.admin.CalendarPingServlet;
import ru.yandex.calendar.util.JettyConfiguration;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

@Configuration
public class MailhookContextConfiguration {
    @Bean
    public MailhookCallbackServlet mailhookCallbackServlet() {
        return new MailhookCallbackServlet();
    }

    @Bean
    public MailhookNewCallbackServlet mailhookCallbackNewServlet() {
        return new MailhookNewCallbackServlet();
    }

    @Bean
    public SingleWarJetty mailhookServiceJetty() {
        SingleWarJetty jetty = JettyConfiguration.fromProperties("mailhook").consJetty();

        jetty.addServletMapping("/ping/*", pingConfigurableServletMailhook());
        jetty.addServletMapping("/mailhook/*", mailhookCallbackServlet());
        jetty.addServletMapping("/mailhook_new/*", mailhookCallbackNewServlet());

        return jetty;
    }

    @Bean
    public CalendarPingServlet pingConfigurableServletMailhook() {
        return new CalendarPingServlet();
    }

    @Bean
    @Qualifier("mailhookService")
    public MailhookService mailhookService() {
        return new MailhookServiceImpl();
    }

    @Bean
    @Qualifier("mailhookNewService")
    public MailhookService mailhookServiceNew() {
        return new MailhookNewServiceImpl();
    }
}
