package ru.yandex.calendar.frontend.mailhook;

import javax.servlet.http.HttpServletRequest;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.core.util.Base64;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import lombok.val;

import ru.yandex.misc.io.InputStreamX;

@Slf4j
public class MailhookNewServiceImpl extends BaseMailhookService {

    private final ObjectMapper objectMapper = new ObjectMapper();

    @SneakyThrows
    @Override
    protected MailhookData prepareMailhookData(HttpServletRequest req) {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        val postData = new InputStreamX(req.getInputStream()).readBytes();
        return objectMapper.readValue(postData, MailhookData.class);
    }

    @Override
    String decodeIcsCalendar(String rawCalendar) {
        return Base64.base64Decode(rawCalendar);
    }
}
