package ru.yandex.calendar.frontend.mailhook;

import javax.servlet.http.HttpServletRequest;

import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import lombok.val;

import ru.yandex.misc.io.InputStreamX;
import ru.yandex.misc.lang.CharsetUtils;

@Slf4j
public class MailhookServiceImpl extends BaseMailhookService {

    @SneakyThrows
    @Override
    protected MailhookData prepareMailhookData(HttpServletRequest req) {
        val uid = req.getParameter("yandex-uid");
        val from = req.getParameter("from");
        val to = req.getParameter("to");
        val messageId = req.getParameter("message-id");
        val postfixId = req.getParameter("postfix-id");
        val icsContents = new InputStreamX(req.getInputStream()).readBytes();
        return new MailhookData(
                uid, from, to, messageId, postfixId, new String(icsContents, CharsetUtils.UTF8_CHARSET)
        );
    }

    @Override
    String decodeIcsCalendar(String rawCalendar) {
        return rawCalendar;
    }
}
