package ru.yandex.calendar.frontend.mulca;

import java.util.regex.Pattern;

import javax.annotation.PreDestroy;

import io.micrometer.core.instrument.MeterRegistry;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;

import ru.yandex.calendar.util.HttpClientConfiguration;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.io.http.apache.v4.ReadStringResponseHandler;
import ru.yandex.misc.lang.StringUtils;

/**
 * @url https://wiki.yandex-team.ru/mds/mulcagate/
 */
public class Mulcagate {
    private static final Pattern METRICS_URI = Pattern.compile("^(/gate/get)");
    private final String url;
    private final HttpClient httpClient;

    public Mulcagate(String url, HttpClientConfiguration httpConf, MeterRegistry registry) {
        this.url = url;
        this.httpClient = httpConf.consClient(registry, "mulcagate", METRICS_URI);
    }

    public String getMail(String stid) {
        HttpGet request = new HttpGet(url + "/get/" + stid + "?raw");

        String response = ApacheHttpClientUtils.execute(request, httpClient, new ReadStringResponseHandler());

        return response.contains("</message>\n")
                ? StringUtils.substringAfter(response, "</message>\n")
                : response;
    }

    @PreDestroy
    public void close() {
        ApacheHttpClientUtils.stopQuietly(httpClient);
    }
}
