package ru.yandex.calendar.frontend.web;

import java.io.IOException;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.commune.json.JsonNumber;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.ip.IpAddress;

public final class AuthInfo {
    public final PassportUidOrZero uid;
    public final Option<IpAddress> ip;
    public final Option<String> yandexuid;

    public AuthInfo(PassportUidOrZero uid, Option<IpAddress> ip, Option<String> yandexuid) {
        this.uid = uid;
        this.ip = ip;
        this.yandexuid = yandexuid;
    }

    private static final ObjectMapper mapper = new ObjectMapper();

    public static AuthInfo parse(String json) {
        JsonNode node;

        try {
            node = mapper.readTree(json);

        } catch (IOException e) {
            return new AuthInfo(PassportUidOrZero.zero(), Option.empty(), Option.empty());
        }
        return new AuthInfo(
                PassportUidOrZero.fromUid(Cf.Long.parseSafe(node.get("uid").asText()).getOrElse(0L)),
                Option.ofNullable(node.get("ip")).map(JsonNode::asText).filterMap(IpAddress::parseIpAddressO),
                Option.ofNullable(node.get("yandexuid")).map(JsonNode::asText));
    }

    public String serialize() {
        Tuple2List<String, JsonValue> values = Tuple2List.arrayList();

        values.add("uid", JsonNumber.valueOf(uid.getUid()));
        ip.forEach(v -> values.add("ip", JsonString.valueOf(v.format())));
        yandexuid.forEach(v -> values.add("yandexuid", JsonString.valueOf(v)));

        return new JsonObject(values).serialize();
    }
}
