package ru.yandex.calendar.frontend.web;

import javax.annotation.PostConstruct;

import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.calendar.boot.CalendarAppName;
import ru.yandex.calendar.frontend.a3.interceptors.LogActionParametersInterceptor;
import ru.yandex.calendar.frontend.web.a3.CorbaExceptionHandler;
import ru.yandex.calendar.frontend.web.a3.CorbaParameterBinder;
import ru.yandex.calendar.frontend.web.a3.CorbaParameterConverters;
import ru.yandex.calendar.frontend.web.a3.CorbaResultSerializer;
import ru.yandex.calendar.frontend.web.a3.DeduplicateParametersInterceptor;
import ru.yandex.calendar.frontend.web.a3.SetExpirationInterceptor;
import ru.yandex.calendar.tvm.TvmManager;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.ActionConfigurationBuilder;
import ru.yandex.commune.a3.ActionConfigurator;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.misc.version.Version;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

@Configuration
public class CalendarServantA3Configuration {
    @Autowired
    @Qualifier("webNewJetty")
    private SingleWarJetty jetty;
    @Autowired
    @Qualifier("corba")
    private ActionApp actionApp;

    @PostConstruct
    public void configure() {
        jetty.addServletMapping("/corba/*", actionApp.createServlet());
    }

    @Bean
    public CalendarServantImpl calendarServantImpl() {
        return new CalendarServantImpl();
    }

    @Bean
    @Qualifier("corba")
    public ActionApp actionApp(
            CalendarServantImpl calendarServant, CalendarAppName appName, Version version,
            TvmManager tvmManager)
    {
        val application = new ApplicationInfo(appName.appName(), version.getProjectVersion());

        val builder = ActionConfigurationBuilder.cons(application);

        builder.addConverters(CorbaParameterConverters.converters);

        builder.register(new TvmAuthenticationInterceptor(tvmManager));
        builder.register(new CorbaParameterBinder());
        builder.register(new CorbaExceptionHandler());
        builder.register(new CorbaResultSerializer());

        builder.register(new LogActionParametersInterceptor());
        builder.register(new DeduplicateParametersInterceptor());
        builder.register(new SetExpirationInterceptor());

        builder.setResultType(MediaType.APPLICATION_XML);

        return ActionConfigurator.configure(Cf.list(calendarServant), builder);
    }
}
