package ru.yandex.calendar.frontend.web;

import Yandex.Request;
import Yandex.RequestPackage.RequestData;
import Yandex.TagHolder;
import org.jdom.Document;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.a3.CorbaSpecial;
import ru.yandex.calendar.frontend.web.cmd.generic.CommandExecutor;
import ru.yandex.calendar.frontend.web.cmd.run.CommandRunException;
import ru.yandex.calendar.frontend.web.cmd.run.api.CmdCheckUpdateActiveOffice;
import ru.yandex.calendar.frontend.web.cmd.run.api.CmdGetHolidays;
import ru.yandex.calendar.frontend.web.cmd.run.api.CmdGetNearestNotification;
import ru.yandex.calendar.frontend.web.cmd.run.api.CmdIcsAddEvent;
import ru.yandex.calendar.frontend.web.cmd.run.api.CmdSvcAddEvent;
import ru.yandex.calendar.frontend.web.cmd.run.api.CmdSvcCheckSubscr;
import ru.yandex.calendar.frontend.web.cmd.run.api.CmdSvcDelEventExtId;
import ru.yandex.calendar.frontend.web.cmd.run.api.CmdSvcGetEvent;
import ru.yandex.calendar.frontend.web.cmd.run.api.CmdSvcGetEvents2;
import ru.yandex.calendar.frontend.web.cmd.run.api.CmdSvcGetSettings;
import ru.yandex.calendar.frontend.web.cmd.run.auxiliary.CmdGetInfo;
import ru.yandex.calendar.frontend.web.cmd.run.auxiliary.CmdGetTimezones;
import ru.yandex.calendar.frontend.web.cmd.run.ui.CmdForceFeedUpdate;
import ru.yandex.calendar.frontend.web.cmd.run.ui.CmdGetHolidaysA;
import ru.yandex.calendar.frontend.web.cmd.run.ui.CmdGetInvitation;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdAttachEvent;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdCheckEventLength;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdCreateEvent;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdCreateOrUpdateEvent;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdDeleteEvent;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdDeleteEventResource;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdDeleteReminder;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdDetachEvent;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdExportEvents;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdGetAvailabilities;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdGetAvailabilityDay;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdGetBusyOverlap;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdGetDefRep;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdGetEvent;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdGetEvent2;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdGetEventIcs;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdGetEventInfos;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdGetEvents;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdGetEventsForWidget;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdHandleEventInvitationDecision;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdParseTimeInEventName;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdUpdateEvent;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.CmdUpdateEventLite;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.attachment.CmdDownloadAttachment;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.attachment.CmdUploadAttachment;
import ru.yandex.calendar.frontend.web.cmd.run.ui.layer.CmdDeleteLayer;
import ru.yandex.calendar.frontend.web.cmd.run.ui.layer.CmdGetLayer;
import ru.yandex.calendar.frontend.web.cmd.run.ui.layer.CmdGetLayerAP;
import ru.yandex.calendar.frontend.web.cmd.run.ui.layer.CmdGetLayers;
import ru.yandex.calendar.frontend.web.cmd.run.ui.layer.CmdHandleLayerInvitationDecision;
import ru.yandex.calendar.frontend.web.cmd.run.ui.layer.CmdLayerUiSetVisible;
import ru.yandex.calendar.frontend.web.cmd.run.ui.layer.CmdObtainLayerPtk;
import ru.yandex.calendar.frontend.web.cmd.run.ui.layer.CmdOpenDefaultLayerCloseEvents;
import ru.yandex.calendar.frontend.web.cmd.run.ui.layer.CmdShareLayer;
import ru.yandex.calendar.frontend.web.cmd.run.ui.layer.CmdSvcUpdateLayer;
import ru.yandex.calendar.frontend.web.cmd.run.ui.layer.CmdUpdateLayerSharing;
import ru.yandex.calendar.frontend.web.cmd.run.ui.resource.CmdGetDomainResourcesWithScheduleLite;
import ru.yandex.calendar.frontend.web.cmd.run.ui.resource.CmdGetMassageSchedule;
import ru.yandex.calendar.frontend.web.cmd.run.ui.settings.CmdGetSettings;
import ru.yandex.calendar.frontend.web.cmd.run.ui.settings.CmdUpdateSettings;
import ru.yandex.calendar.frontend.web.cmd.run.ui.settings.CmdUpdateSettingsOpt;
import ru.yandex.calendar.frontend.web.cmd.run.ui.settings.CmdUpdateTimezone;
import ru.yandex.calendar.frontend.web.cmd.run.ui.todo.CmdCreateTodoItem;
import ru.yandex.calendar.frontend.web.cmd.run.ui.todo.CmdCreateTodoList;
import ru.yandex.calendar.frontend.web.cmd.run.ui.todo.CmdDeleteTodoItem;
import ru.yandex.calendar.frontend.web.cmd.run.ui.todo.CmdDeleteTodoList;
import ru.yandex.calendar.frontend.web.cmd.run.ui.todo.CmdExportTodos;
import ru.yandex.calendar.frontend.web.cmd.run.ui.todo.CmdGetAvailTodoLists;
import ru.yandex.calendar.frontend.web.cmd.run.ui.todo.CmdGetTodoLists;
import ru.yandex.calendar.frontend.web.cmd.run.ui.todo.CmdGetTodoListsSchedule;
import ru.yandex.calendar.frontend.web.cmd.run.ui.todo.CmdReorderTodoItems;
import ru.yandex.calendar.frontend.web.cmd.run.ui.todo.CmdTodoItemSetIsCmpl;
import ru.yandex.calendar.frontend.web.cmd.run.ui.todo.CmdUpdateTodoAll;
import ru.yandex.calendar.frontend.web.cmd.run.ui.todo.CmdUpdateTodoItem;
import ru.yandex.calendar.frontend.web.cmd.run.ui.todo.CmdUpdateTodoList;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.inside.passport.PassportSid;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

@ActionContainer
public class CalendarServantImpl {
    private static final Logger logger = LoggerFactory.getLogger(CalendarServantImpl.class);

    @Autowired
    private CommandExecutor commandExecutor;

    // API

    @Action
    public Document apiSvcGetSettings(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdSvcGetSettings cmd = new CmdSvcGetSettings(auth, rd);
        return commandExecutor.executeCommandAsXml("apiSvcGetSettings", cmd);
    }

    @Action
    public Document apiSvcCheckSubscr(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdSvcCheckSubscr cmd = new CmdSvcCheckSubscr(auth, rd);
        return commandExecutor.executeCommandAsXml("apiSvcCheckSubscr", cmd);
    }

    @Action
    public Document apiSvcGetEvents2(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("tzId") String tzId,
            @RequestParam("layerIds") String layerIds,
            @RequestParam("startTs") String startTs,
            @RequestParam("endTs") String endTs,
            @RequestParam("limit") String limit,
            @RequestParam("onlyVisibleInUi") String onlyVisibleInUi)
    {
        CmdSvcGetEvents2 cmd = new CmdSvcGetEvents2(
                auth, tzId, layerIds, startTs, endTs, limit, onlyVisibleInUi
        );
        return commandExecutor.executeCommandAsXml("apiSvcGetEvents2", cmd);
    }

    @Action
    public Document apiSvcGetEvents2AP(
            @RequestParam("tzId") String tzId,
            @RequestParam("privateToken") String privateToken,
            @RequestParam("startTs") String startTs,
            @RequestParam("endTs") String endTs,
            @RequestParam("limit") String limit,
            @RequestParam("onlyVisibleInUi") String onlyVisibleInUi)
    {
        CmdSvcGetEvents2 cmd = new CmdSvcGetEvents2(
                tzId, privateToken, startTs, endTs, limit, onlyVisibleInUi
        );
        return commandExecutor.executeCommandAsXml("apiSvcGetEvents2AP", cmd);
    }

    @Action
    public Document apiSvcGetEvents3(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("tzId") String tzId,
            @RequestParam("layerIds") String layerIds,
            @RequestParam("startTs") String startTs,
            @RequestParam("endTs") String endTs,
            @RequestParam("limit") String limit,
            @RequestParam("showLimit") String showLimit,
            @RequestParam("onlyVisibleInUi") String onlyVisibleInUi,
            @RequestParam("whoAmI") String whoAmI)
    {
        CmdSvcGetEvents2 cmd = new CmdSvcGetEvents2(
                auth, tzId, layerIds, startTs, endTs,
                limit, showLimit, onlyVisibleInUi, whoAmI, true
        );
        return commandExecutor.executeCommandAsXml("apiSvcGetEvents3", cmd);
    }

    @Action
    public Document apiSvcGetIconName3(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("tzId") String tzId,
            @RequestParam("layerIds") String layerIds,
            @RequestParam("startTs") String startTs,
            @RequestParam("endTs") String endTs,
            @RequestParam("limit") String limit,
            @RequestParam("onlyVisibleInUi") String onlyVisibleInUi,
            @RequestParam("whoAmI") String whoAmI)
    {
        CmdSvcGetEvents2 cmd = new CmdSvcGetEvents2(
                auth, tzId, layerIds, startTs, endTs,
                limit, "0", onlyVisibleInUi, whoAmI, false
        );
        return commandExecutor.executeCommandAsXml("apiSvcGetIconName3", cmd);
    }

    @Action
    public Document apiSvcGetEvents3AP(
            @RequestParam("tzId") String tzId,
            @RequestParam("privateToken") String privateToken,
            @RequestParam("startTs") String startTs,
            @RequestParam("endTs") String endTs,
            @RequestParam("limit") String limit,
            @RequestParam("showLimit") String showLimit,
            @RequestParam("onlyVisibleInUi") String onlyVisibleInUi,
            @RequestParam("whoAmI") String whoAmI)
    {
        CmdSvcGetEvents2 cmd = new CmdSvcGetEvents2(
                tzId, privateToken, startTs, endTs, limit, showLimit, onlyVisibleInUi, whoAmI
        );
        return commandExecutor.executeCommandAsXml("apiSvcGetEvents3AP", cmd);
    }

    @Action
    public Document apiSvcGetEvent(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("sid") long sid,
            @RequestParam("eventExtId") String eventExtId,
            @RequestParam("optEventTs") String optEventTs,
            @RequestParam("isForShow") String isForShow)
    {
        CmdSvcGetEvent cmd = new CmdSvcGetEvent(auth, PassportSid.cons((int) sid), eventExtId, optEventTs, isForShow);
        return commandExecutor.executeCommandAsXml("apiSvcGetEvent", cmd);
    }

    @Action
    public Document apiSvcGetEventCd(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("tzId") String tzId,
            @RequestParam("sid") long sid,
            @RequestParam("uid2") long uid2,
            @RequestParam("controlData") String controlData,
            @RequestParam("eventExtId") String eventExtId,
            @RequestParam("optEventTs") String optEventTs,
            @RequestParam("isForShow") String isForShow)
    {
        Option<PassportUid> uid2O = uid2 == 0 ? Option.<PassportUid>empty() : Option.of(new PassportUid(uid2));
        CmdSvcGetEvent cmd = new CmdSvcGetEvent(
                auth, tzId, PassportSid.cons((int) sid), uid2O, controlData, eventExtId, optEventTs, isForShow
        );
        return commandExecutor.executeCommandAsXml("apiSvcGetEventCd", cmd);
    }

    @Action
    public Document apiSvcAddEvent(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdSvcAddEvent cmd = new CmdSvcAddEvent(auth, rd);
        return commandExecutor.executeCommandAsXml("apiSvcAddEvent", cmd);
    }

    @Action
    public Document apiSvcDelEventExtId(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("sid") long sid,
            @RequestParam("eventExtId") String eventExtId,
            @RequestParam("applyToFuture") String applyToFuture)
    {

        CmdSvcDelEventExtId cmd = new CmdSvcDelEventExtId(auth, PassportSid.cons((int) sid), eventExtId, applyToFuture);
        return commandExecutor.executeCommandAsXml("apiSvcDelEventExtId", cmd);
    }

    @Action
    public Document apiSvcDelEvtExtIdCd(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("sid") long sid,
            @RequestParam("uid2") long uid2,
            @RequestParam("controlData") String controlData,
            @RequestParam("eventExtId") String eventExtId,
            @RequestParam("applyToFuture") String applyToFuture)
    {
        Option<PassportUid> uid2O = uid2 == 0 ? Option.<PassportUid>empty() : Option.of(new PassportUid(uid2));
        CmdSvcDelEventExtId cmd = new CmdSvcDelEventExtId(
                auth, PassportSid.cons((int) sid), uid2O, controlData, eventExtId, applyToFuture
        );
        return commandExecutor.executeCommandAsXml("apiSvcDelEvtExtIdCd", cmd);
    }

    @Action
    public Document apiSvcUpdateLayer(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdSvcUpdateLayer cmd = new CmdSvcUpdateLayer(auth, rd);
        return commandExecutor.executeCommandAsXml("apiSvcUpdateLayer", cmd);
    }

    @Action
    public Document apiIcsAddEvent(
            @CorbaSpecial AuthInfo auth, @CorbaSpecial Request r,
            @RequestParam("contentsName") String contentsName,
            @RequestParam("url") String url,
            @RequestParam("layerInfo") String layerInfo,
            @RequestParam("isFeed") String isFeed)
    {
        CmdIcsAddEvent cmd = new CmdIcsAddEvent(auth, r, contentsName, url, layerInfo);
        cmd.setIsFeed(isFeed);
        return commandExecutor.executeCommandAsXml("apiIcsAddEvent", cmd);
    }

    @Action
    public Document apiIcsAddEventByText(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("srcUrl") String srcUrl,
            @RequestParam("rawText") String rawText,
            @RequestParam("layerInfo") String layerInfo)
    {
        CmdIcsAddEvent cmd = new CmdIcsAddEvent(auth, srcUrl, rawText, layerInfo);
        return commandExecutor.executeCommandAsXml("apiIcsAddEventByText", cmd);
    }

    @Action
    public Document apiIcsAddEventFromMail(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("rawText") String rawText,
            @RequestParam("decision") String decision)
    {
        CmdIcsAddEvent cmd = new CmdIcsAddEvent(auth, rawText, decision);
        return commandExecutor.executeCommandAsXml("apiIcsAddEventFromMail", cmd);
    }

    @Action
    public Document apiGetHolidays(
            @RequestParam("startDate") String startDate,
            @RequestParam("endDate") String endDate,
            @RequestParam("countryId") int countryId,
            @RequestParam("outMode") String outMode)
    {
        CmdGetHolidays cmd = new CmdGetHolidays(startDate, endDate, countryId, outMode);
        return commandExecutor.executeCommandAsXml("apiGetHolidays", cmd);
    }

    @Action
    public Document apiGetHolidays3(
            @RequestParam("startDate") String startDate,
            @RequestParam("endDate") String endDate,
            @RequestParam("countryId") int countryId,
            @RequestParam("outMode") String outMode,
            @RequestParam("forYandex") String forYandex,
            @RequestParam("whoAmI") String whoAmI)
    {
        CmdGetHolidays cmd = new CmdGetHolidays(startDate, endDate, countryId, 0, outMode, forYandex, whoAmI);
        return commandExecutor.executeCommandAsXml("apiGetHolidays3", cmd);
    }

    @Action
    public Document apiGetHolidays4(
            @RequestParam("startDate") String startDate,
            @RequestParam("endDate") String endDate,
            @RequestParam("countryId") int countryId,
            @RequestParam("uid2") long uid2,
            @RequestParam("outMode") String outMode,
            @RequestParam("forYandex") String forYandex,
            @RequestParam("whoAmI") String whoAmI)
    {
        CmdGetHolidays cmd = new CmdGetHolidays(startDate, endDate, countryId, uid2, outMode, forYandex, whoAmI);
        return commandExecutor.executeCommandAsXml("apiGetHolidays4", cmd);
    }

    @Action
    public Document apiGetNearestNtf(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("startTs") String startTs,
            @RequestParam("endTs") String endTs,
            @RequestParam("limit") String limit)
    {
        CmdGetNearestNotification cmd = new CmdGetNearestNotification(auth, startTs, endTs, limit);
        return commandExecutor.executeCommandAsXml("apiGetNearestNtf", cmd);
    }

    @Action
    public Document apiCheckUpdateActiveOffice(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("ipAddress") String ipAddress, @CorbaSpecial TagHolder t)
    {
        CmdCheckUpdateActiveOffice cmd = new CmdCheckUpdateActiveOffice(auth, ipAddress, t);
        return commandExecutor.executeCommandAsXml("apiCheckUpdateActiveOffice", cmd);
    }

    // UI

    @Action
    public Document uiGetHolidaysA(
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType)
    {
        CmdGetHolidaysA cmd = new CmdGetHolidaysA(showDate, viewType, null);
        return commandExecutor.executeCommandAsXml("uiGetHolidaysA", cmd);
    }

    @Action
    public Document uiGetHolidays2A(
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType,
            @RequestParam("holidaysFor") String holidaysFor)
    {
        CmdGetHolidaysA cmd = new CmdGetHolidaysA(showDate, viewType, holidaysFor);
        return commandExecutor.executeCommandAsXml("uiGetHolidays2A", cmd);
    }

    @Action
    public Document uiGetSettings(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("forSettingsPage") String forSettingsPage)
    {
        CmdGetSettings cmd = new CmdGetSettings(auth, forSettingsPage);
        return commandExecutor.executeCommandAsXml("uiGetSettings", cmd);
    }

    @Action
    public Document uiUpdateSettings(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdUpdateSettings cmd = new CmdUpdateSettings(auth, rd);
        return commandExecutor.executeCommandAsXml("uiUpdateSettings", cmd);
    }

    @Action
    public Document uiUpdateSettingsOpt(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdUpdateSettingsOpt cmd = new CmdUpdateSettingsOpt(auth, rd);
        return commandExecutor.executeCommandAsXml("uiUpdateSettingsOpt", cmd);
    }

    @Action
    public Document uiUpdateTimezone(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("geoTzId") String geoTzId,
            @RequestParam("timezoneId") String timezoneId)
    {
        CmdUpdateTimezone cmd = new CmdUpdateTimezone(auth, geoTzId, timezoneId);
        return commandExecutor.executeCommandAsXml("uiUpdateTimezone", cmd);
    }

    @Action
    public Document uiGetLayers(@CorbaSpecial AuthInfo auth) {
        CmdGetLayers cmd = new CmdGetLayers(auth);
        return commandExecutor.executeCommandAsXml("uiGetLayers", cmd);
    }

    @Action
    public Document uiGetLayersT(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("tzId") String tzId,
            @RequestParam("layerIds") String layerIds)
    {
        CmdGetLayers cmd = new CmdGetLayers(auth, tzId, layerIds, null);
        return commandExecutor.executeCommandAsXml("uiGetLayersT", cmd);
    }

    @Action
    public Document uiGetLayersA(
            @RequestParam("tzId") String tzId,
            @RequestParam("layerIds") String layerIds)
    {
        CmdGetLayers cmd = new CmdGetLayers(null, tzId, layerIds, null);
        return commandExecutor.executeCommandAsXml("uiGetLayersA", cmd);
    }

    @Action
    public Document uiGetLayersAP(
            @RequestParam("tzId") String tzId,
            @RequestParam("privateToken") String privateToken)
    {
        CmdGetLayers cmd = new CmdGetLayers(null, tzId, null, privateToken);
        return commandExecutor.executeCommandAsXml("uiGetLayersAP", cmd);
    }

    @Action
    public Document uiGetLayer(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("layerId") long layerId)
    {
        CmdGetLayer r = new CmdGetLayer(auth, layerId);
        return commandExecutor.executeCommandAsXml("uiGetLayer", r);
    }

    @Action
    public Document uiGetLayerAP(
            @RequestParam("tzId") String tzId,
            @RequestParam("privateToken") String privateToken)
    {
        CmdGetLayerAP cmd = new CmdGetLayerAP(tzId, privateToken);
        return commandExecutor.executeCommandAsXml("uiGetLayerAP", cmd);
    }

    @Action
    public Document uiLayerUiSetVisible(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("layerId") long layerId,
            @RequestParam("isVisible") String isVisible)
    {
        CmdLayerUiSetVisible cmd = new CmdLayerUiSetVisible(auth, layerId, isVisible);
        return commandExecutor.executeCommandAsXml("uiLayerUiSetVisible", cmd);
    }

    @Action
    public Document uiCreateLayer(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        throw new CommandRunException("The command is out of order");
    }

    @Action
    public Document uiUpdateLayer(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        throw new CommandRunException("The command is out of order");
    }

    @Action
    public Document uiUpdateLayerSharing(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdUpdateLayerSharing cmd = new CmdUpdateLayerSharing(auth, rd);
        return commandExecutor.executeCommandAsXml("uiUpdateLayerSharing", cmd);
    }

    @Action
    public Document uiDeleteLayer(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("layerId") long layerId,
            @RequestParam("newLayerId") String newLayerId)
    {
        CmdDeleteLayer cmd = new CmdDeleteLayer(auth, layerId, newLayerId);
        return commandExecutor.executeCommandAsXml("uiDeleteLayer", cmd);
    }

    @Action
    public Document uiObtainLayerPtk(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("layerId") long layerId,
            @RequestParam("forceNew") String forceNew)
    {
        CmdObtainLayerPtk cmd = new CmdObtainLayerPtk(auth, layerId, forceNew);
        return commandExecutor.executeCommandAsXml("uiObtainLayerPtk", cmd);
    }

    @Action
    public Document uiShareLayer(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("layerId") long layerId)
    {
        CmdShareLayer cmd = new CmdShareLayer(auth, layerId, null);
        return commandExecutor.executeCommandAsXml("uiShareLayer", cmd);
    }

    @Action
    public Document uiShareLayerP(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("privateToken") String privateToken)
    {
        CmdShareLayer cmd = new CmdShareLayer(auth, null, privateToken);
        return commandExecutor.executeCommandAsXml("uiShareLayerP", cmd);
    }

    @Action
    public Document uiExportEventsAP(
            @RequestParam("tzId") String tzId,
            @RequestParam("privateToken") String privateToken)
    {
        CmdExportEvents cmd = new CmdExportEvents(tzId, privateToken, Option.empty());
        return commandExecutor.executeCommandAsXml("uiExportEventsAP", cmd);
    }

    @Action
    public Document uiExportEvents2AP(
            @RequestParam("tzId") String tzId,
            @RequestParam("privateToken") String privateToken,
            @RequestParam("eTag") String eTag)
    {
        CmdExportEvents cmd = new CmdExportEvents(tzId, privateToken, Option.of(eTag));
        return commandExecutor.executeCommandAsXml("uiExportEventsAP2", cmd);
    }

    @Action
    public Document uiGetEvents(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType)
    {
        CmdGetEvents cmd = new CmdGetEvents(auth, showDate, viewType, null, false, false, null);
        return commandExecutor.executeCommandAsXml("uiGetEvents", cmd);
    }

    @Action
    public Document uiGetEventsT(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("tzId") String tzId,
            @RequestParam("layerIds") String layerIds,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType)
    {
        CmdGetEvents cmd = new CmdGetEvents(auth, tzId, layerIds, null, showDate, viewType, null, false, null);
        return commandExecutor.executeCommandAsXml("uiGetEventsT", cmd);
    }

    @Action
    public Document uiGetEventsA(
            @RequestParam("tzId") String tzId,
            @RequestParam("layerIds") String layerIds,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType)
    {
        CmdGetEvents cmd = new CmdGetEvents(null, tzId, layerIds, null, showDate, viewType, null, false, null);
        return commandExecutor.executeCommandAsXml("uiGetEventsA", cmd);
    }

    @Action
    public Document uiGetEventsAP(
            @RequestParam("tzId") String tzId,
            @RequestParam("privateToken") String privateToken,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType)
    {
        CmdGetEvents cmd = new CmdGetEvents(null, tzId, null, privateToken, showDate, viewType, null, false, null);
        return commandExecutor.executeCommandAsXml("uiGetEventsAP", cmd);
    }

    @Action
    public Document uiGetEvents2(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType,
            @RequestParam("holidaysFor") String holidaysFor)
    {
        CmdGetEvents cmd = new CmdGetEvents(auth, showDate, viewType, holidaysFor, false, false, null);
        return commandExecutor.executeCommandAsXml("uiGetEvents2", cmd);
    }

    @Action
    public Document uiGetEvents2T(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("tzId") String tzId,
            @RequestParam("layerIds") String layerIds,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType,
            @RequestParam("holidaysFor") String holidaysFor)
    {
        CmdGetEvents cmd = new CmdGetEvents(auth, tzId, layerIds, null, showDate, viewType, holidaysFor, false, null);
        return commandExecutor.executeCommandAsXml("uiGetEvents2T", cmd);
    }

    @Action
    public Document uiGetEvents2A(
            @RequestParam("tzId") String tzId,
            @RequestParam("layerIds") String layerIds,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType,
            @RequestParam("holidaysFor") String holidaysFor)
    {
        CmdGetEvents cmd = new CmdGetEvents(null, tzId, layerIds, null, showDate, viewType, holidaysFor, false, null);
        return commandExecutor.executeCommandAsXml("uiGetEvents2A", cmd);
    }

    @Action
    public Document uiGetEvents2AP(
            @RequestParam("tzId") String tzId,
            @RequestParam("privateToken") String privateToken,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType,
            @RequestParam("holidaysFor") String holidaysFor)
    {
        CmdGetEvents cmd = new CmdGetEvents(null, tzId, null, privateToken, showDate, viewType, holidaysFor, false, null);
        return commandExecutor.executeCommandAsXml("uiGetEvents2AP", cmd);
    }

    @Action
    public Document uiGetEvents3(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType,
            @RequestParam("holidaysFor") String holidaysFor,
            @RequestParam("linkSignKey") String linkSignKey)
    {
        CmdGetEvents cmd = new CmdGetEvents(auth, showDate, viewType, holidaysFor, false, false, linkSignKey);
        return commandExecutor.executeCommandAsXml("uiGetEvents2", cmd);
    }

    @Action
    public Document uiGetEvents3T(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("tzId") String tzId,
            @RequestParam("layerIds") String layerIds,
            @RequestParam("showDate") String showDate,

            @RequestParam("viewType") String viewType,
            @RequestParam("holidaysFor") String holidaysFor,
            @RequestParam("linkSignKey") String linkSignKey)
    {
        CmdGetEvents cmd = new CmdGetEvents(auth, tzId, layerIds, null, showDate, viewType, holidaysFor, false, linkSignKey);
        return commandExecutor.executeCommandAsXml("uiGetEvents2T", cmd);
    }

    @Action
    public Document uiGetEvents3A(
            @RequestParam("tzId") String tzId,
            @RequestParam("layerIds") String layerIds,
            @RequestParam("showDate") String showDate,

            @RequestParam("viewType") String viewType,
            @RequestParam("holidaysFor") String holidaysFor,
            @RequestParam("linkSignKey") String linkSignKey)
    {
        CmdGetEvents cmd = new CmdGetEvents(null, tzId, layerIds, null, showDate, viewType, null, false, linkSignKey);
        return commandExecutor.executeCommandAsXml("uiGetEventsA", cmd);
    }

    @Action
    public Document uiGetEvents3AP(
            @RequestParam("tzId") String tzId,
            @RequestParam("privateToken") String privateToken,
            @RequestParam("showDate") String showDate,

            @RequestParam("viewType") String viewType,
            @RequestParam("holidaysFor") String holidaysFor,
            @RequestParam("linkSignKey") String linkSignKey)
    {
        CmdGetEvents cmd = new CmdGetEvents(null, tzId, null, privateToken, showDate, viewType, holidaysFor, false, linkSignKey);
        return commandExecutor.executeCommandAsXml("uiGetEvents2AP", cmd);
    }

    @Action
    public Document uiGetEventsAndReminders(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType,
            @RequestParam("holidaysFor") String holidaysFor)
    {
        CmdGetEvents cmd = new CmdGetEvents(auth, showDate, viewType, holidaysFor, false, true, null);
        return commandExecutor.executeCommandAsXml("uiGetEventsAndReminders", cmd);
    }

    @Action
    public Document uiGetEventsAndReminders3(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType,
            @RequestParam("holidaysFor") String holidaysFor,
            @RequestParam("linkSignKey") String linkSignKey)
    {
        CmdGetEvents cmd = new CmdGetEvents(auth, showDate, viewType, holidaysFor, false, true, linkSignKey);
        return commandExecutor.executeCommandAsXml("uiGetEventsAndReminders", cmd);
    }

    @Action
    public Document uiDeleteReminder(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("clientId") String clientId,
            @RequestParam("externalId") String externalId,
            @RequestParam("idx") String idx)
    {
        CmdDeleteReminder cmd = new CmdDeleteReminder(auth, clientId, externalId, idx);
        return commandExecutor.executeCommandAsXml("uidDeleteReminder", cmd);
    }

    @Action
    public Document uiGetEventsForWidget(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("showDate") String showDate,
            @RequestParam("limit") String limit,
            @RequestParam("onlyVisibleInUi") String onlyVisibleInUi,
            @RequestParam("holidaysFor") String holidaysFor)
    {
        return uiGetEventsForWidget(auth, showDate, null, limit, onlyVisibleInUi, holidaysFor);
    }

    public Document uiGetEventsForWidget(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("showDate") String showDate,
            @RequestParam("outCalendar") String outCalendar,
            @RequestParam("limit") String limit,
            @RequestParam("onlyVisibleInUi") String onlyVisibleInUi,
            @RequestParam("holidaysFor") String holidaysFor)
    {
        CmdGetEventsForWidget cmd = new CmdGetEventsForWidget(
                auth, showDate, outCalendar, limit, onlyVisibleInUi, holidaysFor);

        return commandExecutor.executeCommandAsXml("uiGetEventsForWidget", cmd);
    }

    @Action
    public Document uiGetEventsForWidget2(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("showDate") String showDate,
            @RequestParam("outCalendar") String outCalendar,
            @RequestParam("limit") String limit,
            @RequestParam("onlyVisibleInUi") String onlyVisibleInUi,
            @RequestParam("holidaysFor") String holidaysFor)
    {
        return uiGetEventsForWidget(auth, showDate, outCalendar, limit, onlyVisibleInUi, holidaysFor);
    }

    @Action
    public Document uiGetEventInfos(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("eventIds") String eventIds)
    {
        CmdGetEventInfos cmd = new CmdGetEventInfos(auth, eventIds, null);
        return commandExecutor.executeCommandAsXml("uiGetEventInfos", cmd);
    }

    @Action
    public Document uiGetEventInfos3(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("eventIds") String eventIds,
            @RequestParam("linkSignKey") String linkSignKey)
    {
        CmdGetEventInfos cmd = new CmdGetEventInfos(auth, eventIds, linkSignKey);
        return commandExecutor.executeCommandAsXml("uiGetEventInfos", cmd);
    }

    @Action
    public Document uiGetEventIndents(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType)
    {
        CmdGetEvents cmd = new CmdGetEvents(auth, showDate, viewType, null, true, true, null);
        return commandExecutor.executeCommandAsXml("uiGetEventIndents", cmd);
    }

    @Action
    public Document uiGetEventIndentsT(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("tzId") String tzId,
            @RequestParam("layerIds") String layerIds,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType)
    {
        CmdGetEvents cmd = new CmdGetEvents(auth, tzId, layerIds, null, showDate, viewType, null, true, null);
        return commandExecutor.executeCommandAsXml("uiGetEventIndentsT", cmd);
    }

    @Action
    public Document uiGetEventIndentsA(
            @RequestParam("tzId") String tzId,
            @RequestParam("layerIds") String layerIds,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType)
    {
        CmdGetEvents cmd = new CmdGetEvents(null, tzId, layerIds, null, showDate, viewType, null, true, null);
        return commandExecutor.executeCommandAsXml("uiGetEventIndentsA", cmd);
    }

    @Action
    public Document uiGetEventIndentsAP(
            @RequestParam("tzId") String tzId,
            @RequestParam("privateToken") String privateToken,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType)
    {
        CmdGetEvents cmd = new CmdGetEvents(null, tzId, null, privateToken, showDate, viewType, null, true, null);
        return commandExecutor.executeCommandAsXml("uiGetEventIndentsAP", cmd);
    }

    @Action
    public Document uiGetEventIndents2(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType,
            @RequestParam("holidaysFor") String holidaysFor)
    {
        CmdGetEvents cmd = new CmdGetEvents(auth, showDate, viewType, holidaysFor, true, true, null);
        return commandExecutor.executeCommandAsXml("uiGetEventIndents2", cmd);
    }

    @Action
    public Document uiGetEventIndents2T(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("tzId") String tzId,
            @RequestParam("layerIds") String layerIds,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType,
            @RequestParam("holidaysFor") String holidaysFor)
    {
        CmdGetEvents cmd = new CmdGetEvents(auth, tzId, layerIds, null, showDate, viewType, holidaysFor, true, null);
        return commandExecutor.executeCommandAsXml("uiGetEventIndents2T", cmd);
    }

    @Action
    public Document uiGetEventIndents2A(
            @RequestParam("tzId") String tzId,
            @RequestParam("layerIds") String layerIds,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType,
            @RequestParam("holidaysFor") String holidaysFor)
    {
        CmdGetEvents cmd = new CmdGetEvents(null, tzId, layerIds, null, showDate, viewType, holidaysFor, true, null);
        return commandExecutor.executeCommandAsXml("uiGetEventIndents2A", cmd);
    }

    @Action
    public Document uiGetEventIndents2AP(
            @RequestParam("tzId") String tzId,
            @RequestParam("privateToken") String privateToken,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType,
            @RequestParam("holidaysFor") String holidaysFor)
    {
        CmdGetEvents cmd = new CmdGetEvents(null, tzId, null, privateToken, showDate, viewType, holidaysFor, true, null);
        return commandExecutor.executeCommandAsXml("uiGetEventIndents2AP", cmd);
    }

    @Action
    public Document uiGetBusyOverlap(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdGetBusyOverlap cmd = new CmdGetBusyOverlap(auth, rd);
        return commandExecutor.executeCommandAsXml("uiGetBusyOverlap", cmd);
    }

    @Action
    public Document uiGetAvailabilityDay(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("uid2") long uid2,
            @RequestParam("showDate") String showDate)
    {
        // used to show self availability only
        Option<PassportUid> uid = uid2 == 0 ? Option.<PassportUid>empty() : Option.of(PassportUid.cons(uid2));
        CmdGetAvailabilityDay cmd = new CmdGetAvailabilityDay(auth, uid, showDate);
        return commandExecutor.executeCommandAsXml("uiGetAvailabilityDay", cmd);
    }

    @Action
    public Document uiGetAvailabilitiesDay(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("users") String users,
            @RequestParam("day") String day,
            @RequestParam("timezone") String timezone)
    {
        CmdGetAvailabilities cmd = new CmdGetAvailabilities(auth, users, day, Either.left(1), false, null, timezone, null);
        return commandExecutor.executeCommandAsXml("uiGetAvailabilitiesDay", cmd);
    }

    @Action
    public Document uiGetAvailabilitiesDayForOffice(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("users") String users,
            @RequestParam("day") String day,
            @RequestParam("officeId") String officeId)
    {
        CmdGetAvailabilities cmd = new CmdGetAvailabilities(auth, users, day, Either.left(1), false, officeId, null, null);
        return commandExecutor.executeCommandAsXml("uiGetAvailabilitiesDayForOffice", cmd);
    }

    @Action
    public Document uiGetAvailability(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("user") String user,
            @RequestParam("showDate") String showDate)
    {
        CmdGetAvailabilities cmd = new CmdGetAvailabilities(auth, user, showDate, Either.left(1), true, null, null, null);
        return commandExecutor.executeCommandAsXml("uiGetAvailability", cmd);
    }

    @Action
    public Document uiGetAvailabilityI18n(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("user") String user,
            @RequestParam("showDate") String showDate,
            @RequestParam("lang") String lang)
    {
        CmdGetAvailabilities cmd = new CmdGetAvailabilities(auth, user, showDate, Either.left(7), true, null, null, lang);
        return commandExecutor.executeCommandAsXml("uiGetAvailability", cmd);
    }

    @Action
    public Document uiGetAvailabilitiesDayI18n(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("users") String users,
            @RequestParam("showDate") String showDate,
            @RequestParam("timezone") String timezone,
            @RequestParam("lang") String lang)
    {
        CmdGetAvailabilities cmd = new CmdGetAvailabilities(
                auth, users, showDate, Either.left(1), true, null, timezone, lang);
        return commandExecutor.executeCommandAsXml("uiGetAvailabilitiesDay", cmd);
    }

    @Action
    public Document uiGetAvailabilitiesI18n(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("users") String users,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType,
            @RequestParam("timezone") String timezone,
            @RequestParam("lang") String lang)
    {
        CmdGetAvailabilities cmd = new CmdGetAvailabilities(
                auth, users, showDate, Either.right(viewType), true, null, timezone, lang);
        return commandExecutor.executeCommandAsXml("uiGetAvailabilities", cmd);
    }

    @Action
    public Document uiGetDefRep(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("optEventDate") String optEventDate)
    {
        CmdGetDefRep cmd = new CmdGetDefRep(auth, optEventDate);
        return commandExecutor.executeCommandAsXml("uiGetDefRep", cmd);
    }

    @Action
    public Document uiCheckEventLength(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdCheckEventLength cmd = new CmdCheckEventLength(auth, rd);
        return commandExecutor.executeCommandAsXml("uiCheckEventLength", cmd);
    }

    @Action
    public Document uiGetEvent(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("layerId") long layerId,
            @RequestParam("eventId") long eventId,
            @RequestParam("eventTs") String eventTs,
            @RequestParam("isForShow") String isForShow)
    {
        CmdGetEvent cmd = new CmdGetEvent(auth, layerId, eventId, eventTs, Option.<Integer>empty(), isForShow, null);
        return commandExecutor.executeCommandAsXml("uiGetEvent", cmd);
    }

    @Action
    public Document uiGetEventA(
            @RequestParam("tzId") String tzId,
            @RequestParam("layerId") long layerId,
            @RequestParam("eventId") long eventId,
            @RequestParam("eventTs") String eventTs,
            @RequestParam("isForShow") String isForShow)
    {
        CmdGetEvent cmd = new CmdGetEvent(null, tzId, layerId, eventId, eventTs, Option.<Integer>empty(), isForShow, null);
        return commandExecutor.executeCommandAsXml("uiGetEventA", cmd);
    }

    @Action
    public Document uiGetEventAP(
            @RequestParam("tzId") String tzId,
            @RequestParam("privateToken") String privateToken,
            @RequestParam("eventId") long eventId,
            @RequestParam("eventTs") String eventTs,
            @RequestParam("isForShow") String isForShow)
    {
        CmdGetEvent cmd = new CmdGetEvent(tzId, privateToken, eventId, eventTs, Option.<Integer>empty(), isForShow, null);
        return commandExecutor.executeCommandAsXml("uiGetEventAP", cmd);
    }

    @Action
    public Document uiGetEvent5(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("layerId") long layerId,
            @RequestParam("eventId") long eventId,
            @RequestParam("eventTs") String eventTs,
            @RequestParam("sequence") int sequence,
            @RequestParam("isForShow") String isForShow)
    {
        CmdGetEvent cmd = new CmdGetEvent(auth, layerId, eventId, eventTs, Option.of(sequence), isForShow, null);
        return commandExecutor.executeCommandAsXml("uiGetEvent", cmd);
    }

    @Action
    public Document uiGetEventT5(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("tzId") String tzId,
            @RequestParam("layerId") long layerId,
            @RequestParam("eventId") long eventId,
            @RequestParam("eventTs") String eventTs,
            @RequestParam("sequence") int sequence,
            @RequestParam("isForShow") String isForShow)
    {
        CmdGetEvent cmd = new CmdGetEvent(auth, tzId, layerId, eventId, eventTs, Option.of(sequence), isForShow, null);
        return commandExecutor.executeCommandAsXml("uiGetEventT", cmd);
    }

    @Action
    public Document uiGetEventA5(
            @RequestParam("tzId") String tzId,
            @RequestParam("layerId") long layerId,
            @RequestParam("eventId") long eventId,
            @RequestParam("eventTs") String eventTs,
            @RequestParam("sequence") int sequence,
            @RequestParam("isForShow") String isForShow)
    {
        CmdGetEvent cmd = new CmdGetEvent(null, tzId, layerId, eventId, eventTs, Option.of(sequence), isForShow, null);
        return commandExecutor.executeCommandAsXml("uiGetEventA", cmd);
    }

    @Action
    public Document uiGetEventAP5(
            @RequestParam("tzId") String tzId,
            @RequestParam("privateToken") String privateToken,
            @RequestParam("eventId") long eventId,
            @RequestParam("eventTs") String eventTs,
            @RequestParam("sequence") int sequence,
            @RequestParam("isForShow") String isForShow)
    {
        CmdGetEvent cmd = new CmdGetEvent(tzId, privateToken, eventId, eventTs, Option.of(sequence), isForShow, null);
        return commandExecutor.executeCommandAsXml("uiGetEventAP", cmd);
    }

    @Action
    public Document uiGetEvent6(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("layerId") long layerId,
            @RequestParam("eventId") long eventId,
            @RequestParam("eventTs") String eventTs,
            @RequestParam("sequence") int sequence,
            @RequestParam("isForShow") String isForShow,
            @RequestParam("linkSignKey") String linkSignKey)
    {
        CmdGetEvent cmd = new CmdGetEvent(auth, layerId, eventId, eventTs, Option.of(sequence), isForShow, linkSignKey);
        return commandExecutor.executeCommandAsXml("uiGetEvent", cmd);
    }

    @Action
    public Document uiGetEventT6(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("tzId") String tzId,
            @RequestParam("layerId") long layerId,
            @RequestParam("eventId") long eventId,
            @RequestParam("eventTs") String eventTs,
            @RequestParam("sequence") int sequence,
            @RequestParam("isForShow") String isForShow,
            @RequestParam("linkSignKey") String linkSignKey)
    {
        CmdGetEvent cmd = new CmdGetEvent(auth, tzId, layerId, eventId, eventTs, Option.of(sequence), isForShow, linkSignKey);
        return commandExecutor.executeCommandAsXml("uiGetEventT", cmd);
    }

    @Action
    public Document uiGetEventA6(
            @RequestParam("tzId") String tzId,
            @RequestParam("layerId") long layerId,
            @RequestParam("eventId") long eventId,
            @RequestParam("eventTs") String eventTs,
            @RequestParam("sequence") int sequence,
            @RequestParam("isForShow") String isForShow,
            @RequestParam("linkSignKey") String linkSignKey)
    {
        CmdGetEvent cmd = new CmdGetEvent(null, tzId, layerId, eventId, eventTs, Option.of(sequence), isForShow, linkSignKey);
        return commandExecutor.executeCommandAsXml("uiGetEventA", cmd);
    }

    @Action
    public Document uiGetEventAP6(
            @RequestParam("tzId") String tzId,
            @RequestParam("privateToken") String privateToken,
            @RequestParam("eventId") long eventId,
            @RequestParam("eventTs") String eventTs,
            @RequestParam("sequence") int sequence,
            @RequestParam("isForShow") String isForShow,
            @RequestParam("linkSignKey") String linkSignKey)
    {
        CmdGetEvent cmd = new CmdGetEvent(tzId, privateToken, eventId, eventTs, Option.of(sequence), isForShow, linkSignKey);
        return commandExecutor.executeCommandAsXml("uiGetEventAP", cmd);
    }

    @Action
    public Document uiGetEvent2(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("privateToken") String privateToken,
            @RequestParam("eventId") long eventId,
            @RequestParam("layerId") String layerId,
            @RequestParam("startTs") String startTs)
    {
        CmdGetEvent2 cmd = new CmdGetEvent2(auth, privateToken, eventId, layerId, startTs);
        return commandExecutor.executeCommandAsXml("uiGetEvent2", cmd);
    }

    @Action
    public Document uiGetEvent3(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("layerId") long layerId,
            @RequestParam("eventId") long eventId,
            @RequestParam("eventTs") String eventTs,
            @RequestParam("isForShow") String isForShow,
            @RequestParam("timezone") String timezone)
    {
        CmdGetEvent cmd = new CmdGetEvent(auth, layerId, eventId, eventTs, isForShow, timezone);
        return commandExecutor.executeCommandAsXml("uiGetEvent", cmd);
    }

    @Action
    public Document uiGetEventIcs(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("eventId") long eventId)
    {
        CmdGetEventIcs cmd = new CmdGetEventIcs(auth, eventId);
        return commandExecutor.executeCommandAsXml("uiGetEventIcs", cmd);
    }

    @Action
    public Document uiCreateEvent(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdCreateEvent cmd = new CmdCreateEvent(auth, rd);
        return commandExecutor.executeCommandAsXml("uiCreateEvent", cmd);
    }

    @Action
    public Document uiCreateOrUpdateEvent(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdCreateOrUpdateEvent cmd = new CmdCreateOrUpdateEvent(auth, rd);
        return commandExecutor.executeCommandAsXml("uiCreateOrUpdateEvent", cmd);
    }

    @Action
    public Document uiAttachEvent(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("eventId") long eventId)
    {
        CmdAttachEvent cmd = new CmdAttachEvent(auth, eventId);
        return commandExecutor.executeCommandAsXml("uiAttachEvent", cmd);
    }

    @Action
    public Document uiUpdateEvent(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdUpdateEvent cmd = new CmdUpdateEvent(auth, rd);
        return commandExecutor.executeCommandAsXml("uiUpdateEvent", cmd);
    }

    @Action
    public Document uiUpdateEventLite(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdUpdateEventLite cmd = new CmdUpdateEventLite(auth, rd);
        return commandExecutor.executeCommandAsXml("uiUpdateEventLite", cmd);
    }

    @Action
    public Document uiDeleteEvent(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("eventId") long eventId,
            @RequestParam("eventTs") String eventTs,
            @RequestParam("applyToFuture") String applyToFuture)
    {
        CmdDeleteEvent cmd = new CmdDeleteEvent(auth, eventId, eventTs, Option.<Integer>empty(), applyToFuture);
        return commandExecutor.executeCommandAsXml("uiDeleteEvent", cmd);
    }

    @Action
    public Document uiDeleteEvent2(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("eventId") long eventId,
            @RequestParam("eventTs") String eventTs,
            @RequestParam("applyToFuture") String applyToFuture,
            @RequestParam("timezone") String timezone)
    {
        CmdDeleteEvent cmd = new CmdDeleteEvent(auth, eventId, eventTs, Option.<Integer>empty(), applyToFuture, timezone);
        return commandExecutor.executeCommandAsXml("uiDeleteEvent", cmd);
    }

    @Action
    public Document uiDeleteEvent5(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("eventId") long eventId,
            @RequestParam("eventTs") String eventTs,
            @RequestParam("sequence") int sequence,
            @RequestParam("applyToFuture") String applyToFuture)
    {
        CmdDeleteEvent cmd = new CmdDeleteEvent(auth, eventId, eventTs, Option.of(sequence), applyToFuture);
        return commandExecutor.executeCommandAsXml("uiDeleteEvent", cmd);
    }

    @Action
    public Document uiDeleteEvent25(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("eventId") long eventId,
            @RequestParam("eventTs") String eventTs,
            @RequestParam("sequence") int sequence,
            @RequestParam("applyToFuture") String applyToFuture,
            @RequestParam("timezone") String timezone)
    {
        CmdDeleteEvent cmd = new CmdDeleteEvent(auth, eventId, eventTs, Option.of(sequence), applyToFuture, timezone);
        return commandExecutor.executeCommandAsXml("uiDeleteEvent", cmd);
    }

    @Action
    public Document uiDeleteEventResource(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("exchangeName") String exchangeName,
            @RequestParam("eventId") long eventId,
            @RequestParam("eventTs") String eventTs,
            @RequestParam("applyToFuture") String applyToFuture,
            @RequestParam("sequence") int sequence)
    {
        CmdDeleteEventResource cmd = new CmdDeleteEventResource(
                auth, exchangeName, eventId, eventTs, applyToFuture, sequence);

        return commandExecutor.executeCommandAsXml("uiDeleteEventResource", cmd);
    }

    @Action
    public Document uiDetachEvent(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("eventId") long eventId,
            @RequestParam("layerId") long layerId)
    {
        CmdDetachEvent r = new CmdDetachEvent(auth, eventId, layerId);
        return commandExecutor.executeCommandAsXml("uiDetachEvent", r);
    }

    @Action
    public Document uiParseTimeInEventName2(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("name") String name,
            @RequestParam("date") String date)
    {
        CmdParseTimeInEventName cmd = new CmdParseTimeInEventName(auth, name, date);
        return commandExecutor.executeCommandAsXml("uiParseTimeInEventName2", cmd);
    }

    @Action
    public Document uiForceFeedUpdate(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("feedId") long feedId)
    {
        CmdForceFeedUpdate cmd = new CmdForceFeedUpdate(auth, feedId);
        return commandExecutor.executeCommandAsXml("uiForceFeedUpdate", cmd);
    }

    @Action
    public Document uiCreateTodoList(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdCreateTodoList cmd = new CmdCreateTodoList(auth, rd);
        return commandExecutor.executeCommandAsXml("uiCreateTodoList", cmd);
    }

    @Action
    public Document uiUpdateTodoList(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdUpdateTodoList cmd = new CmdUpdateTodoList(auth, rd);
        return commandExecutor.executeCommandAsXml("uiUpdateTodoList", cmd);
    }

    @Action
    public Document uiDeleteTodoList(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("todoListId") long todoListId)
    {
        CmdDeleteTodoList cmd = new CmdDeleteTodoList(auth, todoListId);
        return commandExecutor.executeCommandAsXml("uiDeleteTodoList", cmd);
    }

    @Action
    public Document uiGetTodoLists(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("todoViewType") String todoViewType)
    {
        CmdGetTodoLists cmd = new CmdGetTodoLists(auth, todoViewType);
        return commandExecutor.executeCommandAsXml("uiGetTodoLists", cmd);
    }

    @Action
    public Document uiGetTodoListsSchedule(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("showDate") String showDate,
            @RequestParam("viewType") String viewType)
    {
        CmdGetTodoListsSchedule cmd = new CmdGetTodoListsSchedule(auth, showDate, viewType);
        return commandExecutor.executeCommandAsXml("uiGetTodoListsSchedule", cmd);
    }

    @Action
    public Document uiGetAvailTodoLists(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("eventId") String eventId)
    {
        CmdGetAvailTodoLists cmd = new CmdGetAvailTodoLists(auth, eventId);
        return commandExecutor.executeCommandAsXml("uiGetAvailTodoLists", cmd);
    }

    @Action
    public Document uiGetTodoList(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("todoViewType") String todoViewType,
            @RequestParam("todoListId") long todoListId)
    {
        CmdGetTodoLists cmd = new CmdGetTodoLists(auth, todoViewType, todoListId);
        return commandExecutor.executeCommandAsXml("uiGetTodoList", cmd);
    }

    @Action
    public Document uiCreateTodoItem(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdCreateTodoItem cmd = new CmdCreateTodoItem(auth, rd);
        return commandExecutor.executeCommandAsXml("uiCreateTodoItem", cmd);
    }

    @Action
    public Document uiUpdateTodoItem(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdUpdateTodoItem cmd = new CmdUpdateTodoItem(auth, rd);
        return commandExecutor.executeCommandAsXml("uiUpdateTodoItem", cmd);
    }

    @Action
    public Document uiDeleteTodoItem(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("todoItemId") long todoItemId)
    {
        CmdDeleteTodoItem cmd = new CmdDeleteTodoItem(auth, todoItemId);
        return commandExecutor.executeCommandAsXml("uiDeleteTodoItem", cmd);
    }

    @Action
    public Document uiTodoItemSetIsCmpl(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("todoItemId") long todoItemId,
            @RequestParam("isCompleted") String isCompleted)
    {
        CmdTodoItemSetIsCmpl cmd = new CmdTodoItemSetIsCmpl(auth, todoItemId, isCompleted);
        return commandExecutor.executeCommandAsXml("uiTodoItemSetIsCmpl", cmd);
    }

    @Action
    public Document uiUpdateTodoAll(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdUpdateTodoAll cmd = new CmdUpdateTodoAll(auth, rd);
        return commandExecutor.executeCommandAsXml("uiUpdateTodoAll", cmd);
    }

    @Action
    public Document uiReorderTodoItems(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdReorderTodoItems cmd = new CmdReorderTodoItems(auth, rd);
        return commandExecutor.executeCommandAsXml("uiReorderTodoItems", cmd);
    }

    @Action
    public Document uiExportTodos(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("todoListIds") String todoListIds)
    {
        CmdExportTodos cmd = new CmdExportTodos(auth, todoListIds);
        return commandExecutor.executeCommandAsXml("uiExportTodos", cmd);
    }

    @Action
    public Document uiExportTodosAP(
            @RequestParam("privateToken") String privateToken,
            @RequestParam("todoListIds") String todoListIds)
    {
        CmdExportTodos cmd = new CmdExportTodos(privateToken, todoListIds);
        return commandExecutor.executeCommandAsXml("uiExportTodosAP", cmd);
    }

    @Action
    public Document uiGetAllContacts(@CorbaSpecial AuthInfo auth) {
        throw new UnsupportedOperationException("deprecated API has been broken");
    }

    @Action
    public Document uiDeleteContacts(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("contacts") String contacts) {
        throw new UnsupportedOperationException("deprecated API has been broken");
    }

    @Action
    public Document uiHandleEventInvDecision2(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd,
            @RequestParam("privateToken") String privateToken,
            @RequestParam("eventId") String eventId)
    {
        CmdHandleEventInvitationDecision cmd = new CmdHandleEventInvitationDecision(auth, rd, privateToken, eventId);
        return commandExecutor.executeCommandAsXml("uiHandleEventInvDecision", cmd);
    }

    @Action
    public Document uiHandleLayerInvDecision2(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd,
            @RequestParam("privateToken") String privateToken,
            @RequestParam("layerId") String layerId)
    {
        CmdHandleLayerInvitationDecision cmd = new CmdHandleLayerInvitationDecision(auth, rd, privateToken, layerId);
        return commandExecutor.executeCommandAsXml("uiHandleLayerInvDecision", cmd);
    }

    @Action
    public Document uiGetInvitation2(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("privateToken") String privateToken,
            @RequestParam("eventId") String eventId)
    {
        CmdGetInvitation cmd = new CmdGetInvitation(auth, privateToken, eventId);
        return commandExecutor.executeCommandAsXml("uiGetInvitation", cmd);
    }

    @Action
    public Document uiGetAllContactsWithResources(@CorbaSpecial AuthInfo auth) {
        throw new UnsupportedOperationException("deprecated API has been broken");
    }

    @Action
    public Document uiGetResourcesWithScheduleLiteI18n(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("day") String day,
            @RequestParam("officeId") String officeId,
            @RequestParam("viewType") String viewType,
            @RequestParam("lang") String lang)
    {
        CmdGetDomainResourcesWithScheduleLite cmd =
                new CmdGetDomainResourcesWithScheduleLite(auth, day, officeId, viewType, lang);
        return commandExecutor.executeCommandAsXml("uiGetResourcesWithScheduleLite", cmd);
    }

    @Action
    public Document uiGetMassageSchedule(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("day") String day,
            @RequestParam("exchangeName") String exchangeName)
    {
        CmdGetMassageSchedule cmd = new CmdGetMassageSchedule(auth, day, exchangeName);
        return commandExecutor.executeCommandAsXml("uiGetMassageSchedule", cmd);
    }

    @Action
    public Document uiOpenDefaultLayerCloseEvents(@CorbaSpecial AuthInfo auth) {
        CmdOpenDefaultLayerCloseEvents cmd = new CmdOpenDefaultLayerCloseEvents(auth);
        return commandExecutor.executeCommandAsXml("uiOpenDefaultLayerCloseEvents", cmd);
    }

    @Action
    public Document uiUploadAttachment(
            @CorbaSpecial AuthInfo auth, @CorbaSpecial Request r,
            @RequestParam("filePartName") String filePartName)
    {
        CmdUploadAttachment cmd = new CmdUploadAttachment(auth, r, filePartName);
        return commandExecutor.executeCommandAsXml("uiUploadAttachment", cmd);
    }

    @Action
    public Document uiDownloadAttachment(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("id") String id, @CorbaSpecial Request r)
    {
        CmdDownloadAttachment cmd = new CmdDownloadAttachment(auth, id, r);
        return commandExecutor.executeCommandAsXml("uiDownloadAttachment", cmd);
    }

    @Action
    public Document auxGetInfo(@CorbaSpecial AuthInfo auth, @CorbaSpecial RequestData rd) {
        CmdGetInfo cmd = new CmdGetInfo(auth, rd);
        return commandExecutor.executeCommandAsXml("auxGetInfo", cmd);
    }

    @Action
    public Document auxGetInfoKeysOnly(
            @CorbaSpecial AuthInfo auth,
            @RequestParam("keys") String keys)
    {
        CmdGetInfo cmd = new CmdGetInfo(auth, keys);
        return commandExecutor.executeCommandAsXml("auxGetInfoKeysOnly", cmd);
    }

    @Action
    public Document auxGetTimezones(@CorbaSpecial TagHolder t) {
        CmdGetTimezones cmd = new CmdGetTimezones(t);
        return commandExecutor.executeCommandAsXml("auxGetTimezones", cmd);
    }

} // Calendar
