package ru.yandex.calendar.frontend.web;

import lombok.AllArgsConstructor;
import lombok.val;

import ru.yandex.calendar.frontend.HeaderUtils;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.tvm.TvmManager;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.commune.a3.utils.Ordered;

@AllArgsConstructor
public class TvmAuthenticationInterceptor implements ActionInvocationInterceptor {
    private final TvmManager tvmManager;

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        val reader = HeaderUtils.getHeaderReader(invocation);
        // By default, if nothing is sent in request itself, we use by default WEB
        tvmManager.handleServiceTicket(reader, ActionSource.WEB);

        return invocation.invoke();
    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE;
    }
}
