package ru.yandex.calendar.frontend.web.a3;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.cmd.generic.CommandErrors;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.result.error.ExceptionHandler;
import ru.yandex.commune.a3.action.result.error.ExceptionResolver;
import ru.yandex.commune.a3.utils.Ordered;

public class CorbaExceptionHandler implements ExceptionHandler {
    @Override
    public Option<?> handleException(
            WebRequest webRequest, ActionInvocationContext invocationContext,
            ExceptionResolver exceptionResolver, Exception exception)
    {
        return Option.of(CommandErrors.createServantFailedDoc("", exception));
    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }
}
