package ru.yandex.calendar.frontend.web.a3;

import java.lang.reflect.Proxy;

import Yandex.Request;
import Yandex.RequestPackage.ParamValue;
import Yandex.RequestPackage.RequestData;
import Yandex.TagHolder;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.interceptors.LoggingParameterBinder;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.Parameter;
import ru.yandex.commune.a3.action.parameter.ParameterDescriptor;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.parameter.bind.ParameterBinder;
import ru.yandex.commune.a3.utils.ParameterRef;
import ru.yandex.commune.a3.utils.ParameterRetriever;
import ru.yandex.commune.a3.utils.ParameterRetrieverFactory;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.reflection.TypeX;
import ru.yandex.misc.web.servlet.MultipartHttpServletRequestX;
import ru.yandex.misc.web.servlet.multipart.CommonsMultipartResolver;
import ru.yandex.misc.web.servlet.multipart.MultipartFile;
import ru.yandex.misc.web.servlet.multipart.MultipartResolver;

public class CorbaParameterBinder implements ParameterBinder, LoggingParameterBinder {
    private final ParameterRetriever<PassportUidOrZero> uidRetriever = ParameterRetrieverFactory.cons(
            PassportUidOrZero.class, ParameterRef.request("uid"));

    private final MultipartResolver multipartResolver = new CommonsMultipartResolver();

    @Override
    public Object createAndBind(
            WebRequest request, ActionInvocationContext context, ParameterDescriptor parameter)
    {
        TypeX type = parameter.getParameterType().getActualType();

        if (type.sameAs(AuthInfo.class)) {
            return new AuthInfo(
                    uidRetriever.retrieve(request, context).getOrElse(PassportUidOrZero::zero),
                    request.getHttpServletRequest().getXRealIp(),
                    request.getHeader("X-Yandexuid"));
        }
        if (type.sameAs(RequestData.class)) {
            ListF<ParamValue> queryArgs = request.getHttpServletRequest()
                    .getParameterMap1().entries().map(ParamValue::new);

            return new RequestData("", "", "",
                    queryArgs.toArray(ParamValue.class), new ParamValue[0], new ParamValue[0]);
        }
        if (type.sameAs(Request.class)) {
            MultipartHttpServletRequestX mp = multipartResolver.resolveMultipart(request.getHttpServletRequest());

            return Proxy.newProxyInstance(CorbaParameterBinder.class.getClassLoader(),
                    new Class[] { Request.class }, (proxy, m, args) -> {
                        if (m.getName().equals("getRemoteFile")) {
                            return mp.getFileO((String) args[0]).map(MultipartFile::getBytes).getOrNull();
                        }
                        if (m.getName().equals("getRemoteFilename")) {
                            return mp.getFileO((String) args[0]).map(MultipartFile::getName).getOrNull();
                        }
                        if (m.getName().equals("getRequestData")) {
                            return null;
                        }
                        throw new UnsupportedOperationException();
                    });
        }
        if (type.sameAs(TagHolder.class)) {
            return SetExpirationInterceptor.createTagHolder();
        }
        throw new IllegalStateException("Unknown parameter type: " + type.getShortDeclaration());
    }

    @Override
    public Option<String> getNameForLogging(Parameter parameter) {
        if (getType(parameter).sameAs(String.class)) {
            return Option.of("uid");
        }
        return Option.of(getType(parameter).getShortDeclaration());
    }

    @Override
    public Option<String> getValueForLogging(Parameter parameter) {
        if (getType(parameter).sameAs(String.class)) {
            return Option.of(AuthInfo.parse((String) parameter.getValue().get()).uid.toString());
        }
        return Option.empty();
    }

    private static TypeX getType(Parameter parameter) {
        return parameter.getDescriptor().getParameterType().getActualType();
    }
}
