package ru.yandex.calendar.frontend.web.a3;

import javax.annotation.Nullable;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.convert.ConverterToType;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author dbrylev
 */
public class CorbaParameterConverters {

    public static final ListF<ConverterToType<?>> converters = Cf.list(
            new ConverterToString(), new ConverterToLong(), new ConverterToInt());


    private static class ConverterToString implements ConverterToType<String> {
        public String convert(@Nullable String s, ActionInvocationContext invocationContext) {
            return StringUtils.isEmpty(s) ? "" : s;
        }
    }

    private static class ConverterToLong implements ConverterToType<Long> {
        public Long convert(@Nullable String s, ActionInvocationContext invocationContext) {
            return StringUtils.isEmpty(s) ? 0L : Long.parseLong(s);
        }
    }

    private static class ConverterToInt implements ConverterToType<Integer> {
        public Integer convert(@Nullable String s, ActionInvocationContext invocationContext) {
            return StringUtils.isEmpty(s) ? 0 : Integer.parseInt(s);
        }
    }
}
