package ru.yandex.calendar.frontend.web.a3;

import java.util.Date;

import Yandex.TagHolder;
import lombok.val;
import org.apache.http.HttpHeaders;
import org.apache.http.client.utils.DateUtils;

import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.commune.a3.utils.Ordered;
import ru.yandex.misc.ThreadLocalX;

public class SetExpirationInterceptor implements ActionInvocationInterceptor {
    private static final ThreadLocalX<TagHolder> tagHolder = new ThreadLocalX<>();

    public static TagHolder createTagHolder() {
        tagHolder.set(new TagHolder());

        return tagHolder.get();
    }

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        try {
            val result = invocation.invoke();

            tagHolder.getO().map(h -> h.value).forEach(tag -> {
                if (tag != null && tag.expireTime > 0) {
                    invocation.getContext().getHttpContext().setHeader(
                            HttpHeaders.EXPIRES, DateUtils.formatDate(new Date(tag.expireTime * 1000L)));
                }
            });
            return result;

        } finally {
            tagHolder.remove();
        }
    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }
}
