package ru.yandex.calendar.frontend.web.cmd.generic;

import lombok.val;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.reflection.ReflectionUtils;

public class ClassFinder {
    public static ListF<ClassX<?>> findClasses(String namePattern) {
        try {
            val resourcePattern = "classpath*:" + namePattern.replace(".", "/") + ".class";
            val resolve = new PathMatchingResourcePatternResolver();
            val resources = resolve.getResources(resourcePattern);
            ListF<ClassX<?>> r = Cf.arrayList();
            // ugly
            val fixedPrefix = namePattern.replace(".", "/").replaceFirst("\\*.*", "");
            for (Resource resource : resources) {
                val className = resource.getURI().toString().replaceAll(".*" + fixedPrefix, fixedPrefix).replaceAll("/", ".").replaceAll(".class$", "");
                Check.notEmpty(className);
                r.add(ClassX.forName(className));
            }
            return r;
        } catch (Exception e) {
            throw ReflectionUtils.translate(e);
        }
    }
}
