package ru.yandex.calendar.frontend.web.cmd.generic;

import org.jdom.Document;
import org.jdom.Element;

import ru.yandex.calendar.frontend.a3.error.ReadableErrorMessageSource;
import ru.yandex.calendar.frontend.web.cmd.run.CommandRunException;
import ru.yandex.calendar.frontend.web.cmd.run.ErrorType;
import ru.yandex.calendar.frontend.web.cmd.run.PermissionDeniedUserException;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.logic.user.NameI18n;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.commune.a3.action.result.error.CommonErrorNames;
import ru.yandex.commune.a3.action.result.error.ErrorNameSource;
import ru.yandex.commune.web.action.result.ErrorResult;
import ru.yandex.misc.ExceptionUtils;

/**
 * @author Stepan Koltsov
 */
public class CommandErrors {

    public static Element serialize(Throwable throwable) {
        if (throwable instanceof CommandRunException)
            return ((CommandRunException) throwable).getRootElement();
        else {
            Element r = serializeDefault(throwable);
            if (throwable instanceof PermissionDeniedUserException) {
                addCodeCommon(r, ErrorType.PERMISSION);
            }
            return r;
        }
    }

    public static Element serialize(CommandRunException e) {
        return e.getRootElement();
    }

    public static Element serializeDefault(Throwable t) {
        Element reasonElement = new Element(CommandRunException.REASON_TAG_NAME);
        reasonElement.setText(t.toString());

        Element r = new Element(CommandRunException.ROOT_TAG_NAME);
        r.addContent(reasonElement);

        if (t instanceof CommandRunException) {
            if (((CommandRunException) t).getSituation().isPresent())
                CalendarXmlizer.setAttr(r, CommandRunException.SITUATION_CODE_ATTR_NAME, ((CommandRunException) t).getSituation().get().getCode());
        }
        if (t instanceof ReadableErrorMessageSource) {
            Element messageElement = new Element(CommandRunException.READABLE_TAG_NAME);
            NameI18n message = ((ReadableErrorMessageSource) t).getReadableMessage();

            CalendarXmlizer.appendElm(messageElement, "ru", message.getName(Language.RUSSIAN));
            CalendarXmlizer.appendElm(messageElement, "en", message.getName(Language.ENGLISH));

            r.addContent(messageElement);
        }
        String errorName = t instanceof ErrorNameSource ? ((ErrorNameSource) t).getErrorName() : CommonErrorNames.UNKNOWN;
        CalendarXmlizer.setAttr(r, CommandRunException.ERR_NAME_ATTR_NAME, errorName);

        return r;
    }

    /**
     * @see ErrorResult
     */
    public static Document createServantFailedDoc(XmlCommand cmd, Throwable e) {
        return createServantFailedDoc(cmd.getTagName(), e);
    }

    public static Document createServantFailedDoc(String tagName, Throwable e) {
        Element eRoot = new Element("servant-failed");
        CalendarXmlizer.setAttr(eRoot, "tag-name", tagName); // for consistency @ xml search
        eRoot.addContent(serialize(e));

        {
            Element stackTraceE = new Element(ErrorResult.STACK_TRACE_ELEMENT);
            stackTraceE.addContent(ExceptionUtils.getStackTrace(e));
            eRoot.addContent(stackTraceE);
        }

        return new Document(eRoot);
    }

    // Adds code tag to own element and returns code tag to allow its further modifications
    public static Element addCodeCommon(Element root, ErrorType et) {
        Element eCode = new Element(et.getAsTagName());
        root.addContent(eCode).setAttribute(CommandRunException.ERR_TYPE_ATTR_NAME, et.getAsAttrValue());
        return eCode;
    }

} //~
