package ru.yandex.calendar.frontend.web.cmd.generic;

import Yandex.RequestPackage.RequestData;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;

/**
 * Command that accepts request.
 * Can use aliases.
 * NOTE: normally accepts null rw; in this case - produces null data provider.
 * @author ssytnik
 */
public abstract class ReqProcessingXmlCommand extends UserXmlCommand {
    public ReqProcessingXmlCommand(String cmdTagName, RequestData requestData, AuthInfo ai) {
        super(cmdTagName, requestData, ai);
    }

    @Override
    protected final void buildXmlResponseU(XmlCmdContext ctx) {
        AliasedRequestDataProvider dp = rw != null ? new AliasedRequestDataProvider(rw) : null;
        buildXmlResponseRP(ctx, dp);
    }

    // ABSTRACT //

    protected abstract void buildXmlResponseRP(XmlCmdContext ctx, AliasedRequestDataProvider dp);
}
