package ru.yandex.calendar.frontend.web.cmd.generic;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;

/**
 * Command that validates incoming request and/or other parameters passed to the command.
 * If validation fails, the output document will contain a command-run-exception tag
 * with a validation failure reason and a validation-related sub-tags.
 * For more details,
 * see {@link ru.yandex.calendar.util.validation.RequestValidator}
 * and {@link ru.yandex.calendar.frontend.web.cmd.run.CommandRunException}.
 *
 * @author ssytnik
 */
public abstract class ValidatableXmlCommand extends UserXmlCommand {

    // AUTHORIZED CTORS

    public ValidatableXmlCommand(String cmdTagName, AuthInfo ai) {
        super(cmdTagName, ai);
    }

    public ValidatableXmlCommand(String cmdTagName, AuthInfo ai, String tzId) {
        super(cmdTagName, ai, tzId);
    }

    // ANONYMOUS CTORS

    public ValidatableXmlCommand(String cmdTagName, String tzId) {
        super(cmdTagName, tzId);
    }

    public ValidatableXmlCommand(String cmdTagName) {
        super(cmdTagName);
    }

    @Override
    protected final void buildXmlResponseU(XmlCmdContext ctx) {
        validate();
        buildXmlResponseV(ctx);
    }

    // ABSTRACT //

    protected abstract void validate();
    protected abstract void buildXmlResponseV(XmlCmdContext ctx);
}
