package ru.yandex.calendar.frontend.web.cmd.run;

import javax.annotation.Nullable;

import org.jdom.Element;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.calendar.CalendarException;
import ru.yandex.calendar.frontend.web.cmd.generic.CommandErrors;
import ru.yandex.commune.a3.action.result.error.ErrorNameSource;

/**
 * Shows error message to the user instead of throwing
 * {@link Yandex.ComponentPackage.ServantFailed} exception
 *
 * @author ssytnik
 */
@SuppressWarnings("serial")
public class CommandRunException extends CalendarException implements ErrorNameSource {
    public static final String ROOT_TAG_NAME = "command-run-error"; // {root_tag}
    public static final String SITUATION_CODE_ATTR_NAME = "situation-code"; // {root_tag {sit_code_attr}}
    public static final String ERR_TYPE_ATTR_NAME = "type"; // {root_tag {err_type_attr}}
    public static final String ERR_NAME_ATTR_NAME = "error-name"; // {root_tag {err_name_attr}}
    public static final String REASON_TAG_NAME = "reason"; // {root_tag}/{reason_tag}
    public static final String READABLE_TAG_NAME = "readable";

    private boolean admissibleError; // if true, then we're tolerant (no stack trace in CommandUtils, etc.)
    private final Option<Situation> situation;

    public CommandRunException(String reason) {
        this(reason, null);
    }

    public CommandRunException(Throwable t) {
        this(null, t);
    }

    public CommandRunException(String reason, Throwable cause) {
        this(reason, cause, Option.<Situation>empty());
    }

    public CommandRunException(@Nullable String reason, @Nullable Throwable cause, Option<Situation> situation) {
        super(reason, cause);
        admissibleError = false;
        this.situation = situation;
    }

    @Override
    public String getErrorName() {
        if (situation.isPresent()) {
            return situation.get().getTitle();
        } else {
            return "unknown";
        }
    }

    public Element getRootElement() {
        return CommandErrors.serializeDefault(this);
    }

    public boolean isAdmissibleError() { return admissibleError; }

    public void setAdmissibleError(boolean admissibleError) {
        this.admissibleError = admissibleError;
    }


    // Optional error codes

    // Situations

    public boolean isSituation(Situation s) {
        return situation.isPresent() && situation.get() == s;
    }

    public Option<Situation> getSituation() {
        return situation;
    }

    public static CommandRunException createSituation(String msg, Situation s) {
        return new CommandRunException(msg, null, Option.of(s));
    }

    public static CommandRunException createSituation(Throwable t, Situation s) {
        return new CommandRunException(null, t, Option.of(s));
    }

    public static Function0<CommandRunException> createSituationF(final String msg, final Situation s) {
        return () -> createSituation(msg, s);
    }

}
