package ru.yandex.calendar.frontend.web.cmd.run;

import ru.yandex.misc.lang.CamelWords;

/**
 * Error types for command run exception.
 *
 * Errors are checked in xsl/errors.xsl.
 *
 * @author ssytnik
 */
public enum ErrorType {
    /**
     * permission check fails (medium severity)
     */
    PERMISSION(true),
    ;

    private final boolean errorEndingInTagName;

    private ErrorType(boolean errorEndingInTagName) {
        this.errorEndingInTagName = errorEndingInTagName;
    }

    public String getAsAttrValue() { return CamelWords.parse(this.name()).toXmlName(); }
    public String getAsTagName() {
        return getAsAttrValue() + (errorEndingInTagName ? "-error" : "");
    }
}
