package ru.yandex.calendar.frontend.web.cmd.run;

import ru.yandex.bolts.collection.Either;
import ru.yandex.calendar.micro.perm.EventAction;
import ru.yandex.calendar.micro.perm.LayerAction;

public class EventOrLayerAction {
    private final Either<EventAction, LayerAction> action;

    private EventOrLayerAction(Either<EventAction, LayerAction> action) {
        this.action = action;
    }

    public boolean isEventAction() {
        return action.isLeft();
    }

    public boolean isLayerAction() {
        return action.isRight();
    }

    public EventAction getEventAction() {
        return action.getLeft();
    }

    public LayerAction getLayerAction() {
        return action.getRight();
    }

    public static EventOrLayerAction event(EventAction action) {
        return new EventOrLayerAction(Either.left(action));
    }

    public static EventOrLayerAction layer(LayerAction action) {
        return new EventOrLayerAction(Either.right(action));
    }

    @Override
    public String toString() {
        return isEventAction()
                ? "EventAction." + getEventAction().name()
                : "LayerAction." + getLayerAction().name();
    }
}
