package ru.yandex.calendar.frontend.web.cmd.run;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.CalendarException;
import ru.yandex.commune.a3.action.result.error.ErrorNameSource;

@SuppressWarnings("serial")
public class PermissionDeniedUserException extends CalendarException implements ErrorNameSource {
    private final Option<EventOrLayerAction> actionO;

    public PermissionDeniedUserException() {
        super();
        actionO = Option.empty();
    }

    public PermissionDeniedUserException(String message, Throwable cause) {
        super(message, cause);
        actionO = Option.empty();
    }

    public PermissionDeniedUserException(String message) {
        super(message);
        actionO = Option.empty();
    }

    public PermissionDeniedUserException(String message, EventOrLayerAction action) {
        super(message);
        actionO = Option.of(action);
    }

    public PermissionDeniedUserException(Throwable cause) {
        super(cause);
        actionO = Option.empty();
    }

    @Override
    public String getErrorName() {
        if (actionO.isPresent()) {
            if (actionO.get().isEventAction()) return Situation.NO_PERMISSIONS_FOR_EVENT_ACTION.getTitle();
            if (actionO.get().isLayerAction()) return Situation.NO_PERMISSIONS_FOR_LAYER_ACTION.getTitle();
        }
        return Situation.PERMISSION_ERROR.getTitle();
    }
}
