package ru.yandex.calendar.frontend.web.cmd.run;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.error.ReadableErrorMessageSource;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.logic.user.NameI18n;
import ru.yandex.commune.a3.action.result.error.CommonErrorNames;
import ru.yandex.commune.a3.action.result.error.ErrorNameSource;

/**
 * @author dbrylev
 */
public class ReadableErrorMessageException extends CommandRunException
        implements ReadableErrorMessageSource, ErrorNameSource
{
    private final NameI18n message;

    public ReadableErrorMessageException(NameI18n message) {
        this(message, Option.empty());
    }

    public ReadableErrorMessageException(NameI18n message, Situation situation) {
        this(message, Option.of(situation));
    }

    public ReadableErrorMessageException(NameI18n message, Option<Situation> situation) {
        super(message.getName(Language.ENGLISH), null, situation);
        this.message = message;

        setAdmissibleError(true);
    }

    @Override
    public NameI18n getReadableMessage() {
        return message;
    }

    @Override
    public String getErrorName() {
        return CommonErrorNames.NOT_ACCEPTABLE;
    }
}
