package ru.yandex.calendar.frontend.web.cmd.run;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.Resource;
import ru.yandex.calendar.logic.event.avail.AvailabilityOverlap;

/**
 * @author dbrylev
 */
public class ResourceBusyOverlapException extends CommandRunException {

    private final Resource resource;
    private final AvailabilityOverlap overlap;

    public ResourceBusyOverlapException(String reason, Resource resource, AvailabilityOverlap overlap) {
        super(reason, null, Option.of(Situation.BUSY_OVERLAP));
        this.resource = resource;
        this.overlap = overlap;
    }

    public Resource getResource() {
        return resource;
    }

    public AvailabilityOverlap getOverlap() {
        return overlap;
    }
}
