package ru.yandex.calendar.frontend.web.cmd.run;

/**
 * Concrete situation codes for command run exceptions
 */
public enum Situation {
    TOO_LONG_EVENT(1, "too-long-event"),
    EVENT_LONGER_THAN_REP(2, "event-longer-than-rep"),
    NO_AUTH(5, "no-auth"),
    INV_IS_MISSING(6, "inv-is-missing"),
    ALREADY_SHARED(7, "already-shared"), // or, maybe, pointless to share
    NON_CORRESPONDING_UID(8, "non-corresponding-uid"),
    BUSY_OVERLAP(9, "busy-overlap"),
    CAPTCHA_FAILED(10, "captcha-failed"),
    BAD_RESPONSE_CODE(11, "bad-response-code"),
    ICS_PARSING_ERROR(12, "ics-parsing-error"),
    CANNOT_OPEN_URL_CONN(13, "cannot-open-url-conn"), // inner usage only
    EVENT_ALREADY_EXISTS(14, "event-already-exists"), // inner usage only
    MASTER_UNAVAILABLE(15, "master-unavailable"),
    NOT_YANDEX_USER(16, "not-yandex-user"),
    TODO_ITEM_NOT_FOUND(17, "todo-item-not-found"),
    TODO_ITEM_ALREADY_EXISTS(18, "todo-item-already-exists"),
    TOO_MANY_EMAILS(19, "too-many-emails"),
    TODO_LIST_NOT_FOUND(20, "todo-list-not-found"),
    TODO_LIST_ALREADY_EXISTS(21, "todo-list-already-exists"),
    EXCHANGE_EVENT_CONFLICT(22, "exchange-event-conflict"),
    ICS_FEED_INVALID_URL(23, "ics-feed-invalid-url"),
    ICS_FEED_ALREADY_SUBSCRIBED_URL(24, "ics-feed-already-subscribed-url"),
    NO_PERMISSIONS_FOR_EVENT_ACTION(25, "no-permissions-for-event-action"),
    NO_PERMISSIONS_FOR_LAYER_ACTION(26, "no-permissions-for-layer-action"),
    PERMISSION_ERROR(27, "permission-error"),
    MASSAGE_DENIED(28, "massage-denied"),
    EVENT_NOT_FOUND(29, "event-not-found"),
    EVENT_MODIFIED(30, "event-modified"),
    TOO_SHORT_EVENT(31, "too-short-event"),
    INVALID_TOKEN(32, "invalid-token"),
    EWS_UNSUPPORTED_TIMEZONE(33, "ews-unsupported-timezone"),
    EWS_OCCURRENCES_OVERLAP(34, "ews-occurrences-overlap"),
    EVENT_STARTS_AFTER_DUE(35, "event-starts-after-due"),
    EWS_SET_DECISION_FAILED(36, "ews-failed-to-set-decision"),
    BAD_KARMA(85, "bad-karma"),
    SPAM_DETECTED(86, "spam-detected"),
    MISSING_UID(86, "missing-uid"),
    MISSING_LAYER_ID(86, "missing-layer-id"),
    ;

    private final int code;
    private final String title;

    Situation(int code, String title) {
        this.code = code;
        this.title = title;
    }

    public int getCode() {
        return code;
    }

    public String getTitle() {
        return title;
    }
}
